rule win_bozok_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bozok"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03c0 50 8b450c 50 6a01 6a00 8b45f4 }
            // n = 7, score = 100
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_1 = { 51 68d0070000 e8???????? 68???????? e8???????? 6807800000 e8???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   68d0070000           | push                0x7d0
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   6807800000           | push                0x8007
            //   e8????????           |                     

        $sequence_2 = { a1???????? c6400d00 a1???????? 8b1424 8910 a1???????? 895808 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   c6400d00             | mov                 byte ptr [eax + 0xd], 0
            //   a1????????           |                     
            //   8b1424               | mov                 edx, dword ptr [esp]
            //   8910                 | mov                 dword ptr [eax], edx
            //   a1????????           |                     
            //   895808               | mov                 dword ptr [eax + 8], ebx

        $sequence_3 = { 7419 53 e8???????? 66837c43fe5c 740b 68???????? 53 }
            // n = 7, score = 100
            //   7419                 | je                  0x1b
            //   53                   | push                ebx
            //   e8????????           |                     
            //   66837c43fe5c         | cmp                 word ptr [ebx + eax*2 - 2], 0x5c
            //   740b                 | je                  0xd
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_4 = { 8bf8 33c9 85ff 7426 8bc5 33d2 }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   33c9                 | xor                 ecx, ecx
            //   85ff                 | test                edi, edi
            //   7426                 | je                  0x28
            //   8bc5                 | mov                 eax, ebp
            //   33d2                 | xor                 edx, edx

        $sequence_5 = { 50 e8???????? 83c41c 8bf0 eb3c }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8bf0                 | mov                 esi, eax
            //   eb3c                 | jmp                 0x3e

        $sequence_6 = { 8b07 8b4810 8b07 8b5014 035508 8b45f8 e8???????? }
            // n = 7, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b4810               | mov                 ecx, dword ptr [eax + 0x10]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b5014               | mov                 edx, dword ptr [eax + 0x14]
            //   035508               | add                 edx, dword ptr [ebp + 8]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_7 = { 8b45fc 50 57 e8???????? 85c0 756e }
            // n = 6, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   756e                 | jne                 0x70

        $sequence_8 = { 0f84bc010000 a1???????? 8b00 ffd0 e9???????? 8bd6 8bc3 }
            // n = 7, score = 100
            //   0f84bc010000         | je                  0x1c2
            //   a1????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ffd0                 | call                eax
            //   e9????????           |                     
            //   8bd6                 | mov                 edx, esi
            //   8bc3                 | mov                 eax, ebx

        $sequence_9 = { 7423 8b442404 50 8b442404 }
            // n = 4, score = 100
            //   7423                 | je                  0x25
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   50                   | push                eax
            //   8b442404             | mov                 eax, dword ptr [esp + 4]

    condition:
        7 of them and filesize < 114688
}