rule win_buer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.buer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.buer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bc7 7d0f 8a0c46 880c18 }
            // n = 4, score = 1100
            //   3bc7                 | cmp                 eax, edi
            //   7d0f                 | jge                 0x11
            //   8a0c46               | mov                 cl, byte ptr [esi + eax*2]
            //   880c18               | mov                 byte ptr [eax + ebx], cl

        $sequence_1 = { 40 3bc2 7cf1 eb02 }
            // n = 4, score = 1100
            //   40                   | inc                 eax
            //   3bc2                 | cmp                 eax, edx
            //   7cf1                 | jl                  0xfffffff3
            //   eb02                 | jmp                 4

        $sequence_2 = { 8d5001 85ff 7504 8bc2 }
            // n = 4, score = 1100
            //   8d5001               | lea                 edx, [eax + 1]
            //   85ff                 | test                edi, edi
            //   7504                 | jne                 6
            //   8bc2                 | mov                 eax, edx

        $sequence_3 = { 894144 8b45f0 03c2 8b55e8 015158 }
            // n = 5, score = 1100
            //   894144               | mov                 dword ptr [ecx + 0x44], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   03c2                 | add                 eax, edx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   015158               | add                 dword ptr [ecx + 0x58], edx

        $sequence_4 = { 8b55e8 015158 8b55d8 894148 8b45dc 03c6 }
            // n = 6, score = 1100
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   015158               | add                 dword ptr [ecx + 0x58], edx
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   894148               | mov                 dword ptr [ecx + 0x48], eax
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   03c6                 | add                 eax, esi

        $sequence_5 = { 60 64a130000000 8b400c 8b4014 8b00 8b4010 8945fc }
            // n = 7, score = 1100
            //   60                   | pushal              
            //   64a130000000         | mov                 eax, dword ptr fs:[0x30]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b4014               | mov                 eax, dword ptr [eax + 0x14]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { 8a0c46 880c18 40 3bc2 }
            // n = 4, score = 1100
            //   8a0c46               | mov                 cl, byte ptr [esi + eax*2]
            //   880c18               | mov                 byte ptr [eax + ebx], cl
            //   40                   | inc                 eax
            //   3bc2                 | cmp                 eax, edx

        $sequence_7 = { 83e801 7420 83e801 740b }
            // n = 4, score = 1100
            //   83e801               | sub                 eax, 1
            //   7420                 | je                  0x22
            //   83e801               | sub                 eax, 1
            //   740b                 | je                  0xd

        $sequence_8 = { 00c0 e9???????? f7da 890c24 8d6801 31c9 be3e000000 }
            // n = 7, score = 300
            //   00c0                 | add                 al, al
            //   e9????????           |                     
            //   f7da                 | neg                 edx
            //   890c24               | mov                 dword ptr [esp], ecx
            //   8d6801               | lea                 ebp, [eax + 1]
            //   31c9                 | xor                 ecx, ecx
            //   be3e000000           | mov                 esi, 0x3e

        $sequence_9 = { 017708 b803000000 31d2 83c418 5e 5f c3 }
            // n = 7, score = 300
            //   017708               | add                 dword ptr [edi + 8], esi
            //   b803000000           | mov                 eax, 3
            //   31d2                 | xor                 edx, edx
            //   83c418               | add                 esp, 0x18
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c3                   | ret                 

        $sequence_10 = { 09f2 09ca 09c2 b801000000 ebd0 }
            // n = 5, score = 300
            //   09f2                 | or                  edx, esi
            //   09ca                 | or                  edx, ecx
            //   09c2                 | or                  edx, eax
            //   b801000000           | mov                 eax, 1
            //   ebd0                 | jmp                 0xffffffd2

        $sequence_11 = { 0fb617 47 89f9 83e23f eb11 8b7c2410 8b5c2408 }
            // n = 7, score = 300
            //   0fb617               | movzx               edx, byte ptr [edi]
            //   47                   | inc                 edi
            //   89f9                 | mov                 ecx, edi
            //   83e23f               | and                 edx, 0x3f
            //   eb11                 | jmp                 0x13
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   8b5c2408             | mov                 ebx, dword ptr [esp + 8]

        $sequence_12 = { 01c7 0fa5da d3e3 8b4c2444 }
            // n = 4, score = 300
            //   01c7                 | add                 edi, eax
            //   0fa5da               | shld                edx, ebx, cl
            //   d3e3                 | shl                 ebx, cl
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]

        $sequence_13 = { 0fa4c208 c1e008 0fb6cb 09c1 89c8 83c414 }
            // n = 6, score = 300
            //   0fa4c208             | shld                edx, eax, 8
            //   c1e008               | shl                 eax, 8
            //   0fb6cb               | movzx               ecx, bl
            //   09c1                 | or                  ecx, eax
            //   89c8                 | mov                 eax, ecx
            //   83c414               | add                 esp, 0x14

        $sequence_14 = { 01cf 0f92c1 08f9 751d }
            // n = 4, score = 300
            //   01cf                 | add                 edi, ecx
            //   0f92c1               | setb                cl
            //   08f9                 | or                  cl, bh
            //   751d                 | jne                 0x1f

        $sequence_15 = { 0f84d7010000 8b442418 8b5c2404 8b54242c 894c2408 01c8 }
            // n = 6, score = 300
            //   0f84d7010000         | je                  0x1dd
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b5c2404             | mov                 ebx, dword ptr [esp + 4]
            //   8b54242c             | mov                 edx, dword ptr [esp + 0x2c]
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   01c8                 | add                 eax, ecx

    condition:
        7 of them and filesize < 3031040
}