rule win_buzus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.buzus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.buzus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd6 59 3bc3 59 8945ec 741a }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx
            //   59                   | pop                 ecx
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   741a                 | je                  0x1c

        $sequence_1 = { 391d???????? 7420 3bcb 741c 391d???????? 7414 391d???????? }
            // n = 7, score = 100
            //   391d????????         |                     
            //   7420                 | je                  0x22
            //   3bcb                 | cmp                 ecx, ebx
            //   741c                 | je                  0x1e
            //   391d????????         |                     
            //   7414                 | je                  0x16
            //   391d????????         |                     

        $sequence_2 = { 8bec 83ec10 56 8bf1 807e0400 7561 6a06 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   807e0400             | cmp                 byte ptr [esi + 4], 0
            //   7561                 | jne                 0x63
            //   6a06                 | push                6

        $sequence_3 = { 750b 68???????? ff15???????? ff75d4 }
            // n = 4, score = 100
            //   750b                 | jne                 0xd
            //   68????????           |                     
            //   ff15????????         |                     
            //   ff75d4               | push                dword ptr [ebp - 0x2c]

        $sequence_4 = { 6a10 68???????? 8d85ecd9ffff 56 50 e8???????? 83c410 }
            // n = 7, score = 100
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   8d85ecd9ffff         | lea                 eax, [ebp - 0x2614]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_5 = { 50 8d85f8fdffff 50 ffd6 8bf8 85ff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi

        $sequence_6 = { 8975dc 0fb68503ffffff 0fb6b512ffffff 8955d0 8945bc }
            // n = 5, score = 100
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi
            //   0fb68503ffffff       | movzx               eax, byte ptr [ebp - 0xfd]
            //   0fb6b512ffffff       | movzx               esi, byte ptr [ebp - 0xee]
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax

        $sequence_7 = { 32c3 741c 3c0a 7418 3c0d 7414 3c5c }
            // n = 7, score = 100
            //   32c3                 | xor                 al, bl
            //   741c                 | je                  0x1e
            //   3c0a                 | cmp                 al, 0xa
            //   7418                 | je                  0x1a
            //   3c0d                 | cmp                 al, 0xd
            //   7414                 | je                  0x16
            //   3c5c                 | cmp                 al, 0x5c

        $sequence_8 = { 1bc0 83e003 e9???????? 6a06 }
            // n = 4, score = 100
            //   1bc0                 | sbb                 eax, eax
            //   83e003               | and                 eax, 3
            //   e9????????           |                     
            //   6a06                 | push                6

        $sequence_9 = { 83c418 33db 8d85d8faffff 53 53 53 53 }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   33db                 | xor                 ebx, ebx
            //   8d85d8faffff         | lea                 eax, [ebp - 0x528]
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 679936
}