rule win_caddywiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.caddywiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.caddywiper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6852bffffff50 c6852cffffff72 c6852dffffff69 c6852effffff76 }
            // n = 4, score = 100
            //   c6852bffffff50       | mov                 byte ptr [ebp - 0xd5], 0x50
            //   c6852cffffff72       | mov                 byte ptr [ebp - 0xd4], 0x72
            //   c6852dffffff69       | mov                 byte ptr [ebp - 0xd3], 0x69
            //   c6852effffff76       | mov                 byte ptr [ebp - 0xd2], 0x76

        $sequence_1 = { c68523ffffff77 c68524ffffff6e c68525ffffff65 c68526ffffff72 c68527ffffff73 c68528ffffff68 c68529ffffff69 }
            // n = 7, score = 100
            //   c68523ffffff77       | mov                 byte ptr [ebp - 0xdd], 0x77
            //   c68524ffffff6e       | mov                 byte ptr [ebp - 0xdc], 0x6e
            //   c68525ffffff65       | mov                 byte ptr [ebp - 0xdb], 0x65
            //   c68526ffffff72       | mov                 byte ptr [ebp - 0xda], 0x72
            //   c68527ffffff73       | mov                 byte ptr [ebp - 0xd9], 0x73
            //   c68528ffffff68       | mov                 byte ptr [ebp - 0xd8], 0x68
            //   c68529ffffff69       | mov                 byte ptr [ebp - 0xd7], 0x69

        $sequence_2 = { ff954cf7ffff 8985e0f1ffff 83bde0f1ffffff 7505 e9???????? }
            // n = 5, score = 100
            //   ff954cf7ffff         | call                dword ptr [ebp - 0x8b4]
            //   8985e0f1ffff         | mov                 dword ptr [ebp - 0xe20], eax
            //   83bde0f1ffffff       | cmp                 dword ptr [ebp - 0xe20], -1
            //   7505                 | jne                 7
            //   e9????????           |                     

        $sequence_3 = { c645f26c c645f300 c645f400 c645f500 c645d043 }
            // n = 5, score = 100
            //   c645f26c             | mov                 byte ptr [ebp - 0xe], 0x6c
            //   c645f300             | mov                 byte ptr [ebp - 0xd], 0
            //   c645f400             | mov                 byte ptr [ebp - 0xc], 0
            //   c645f500             | mov                 byte ptr [ebp - 0xb], 0
            //   c645d043             | mov                 byte ptr [ebp - 0x30], 0x43

        $sequence_4 = { c645c06b c645c165 c645c26e c645c350 c645c472 }
            // n = 5, score = 100
            //   c645c06b             | mov                 byte ptr [ebp - 0x40], 0x6b
            //   c645c165             | mov                 byte ptr [ebp - 0x3f], 0x65
            //   c645c26e             | mov                 byte ptr [ebp - 0x3e], 0x6e
            //   c645c350             | mov                 byte ptr [ebp - 0x3d], 0x50
            //   c645c472             | mov                 byte ptr [ebp - 0x3c], 0x72

        $sequence_5 = { 50 8d8db4fbffff 51 e8???????? 83c408 89854cf7ffff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d8db4fbffff         | lea                 ecx, [ebp - 0x44c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   89854cf7ffff         | mov                 dword ptr [ebp - 0x8b4], eax

        $sequence_6 = { 8b4df0 51 e8???????? 83c404 8945e8 837de800 0f84dc000000 }
            // n = 7, score = 100
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   0f84dc000000         | je                  0xe2

        $sequence_7 = { e8???????? 83c408 89854cffffff c745fc00000000 c68538ffffff43 c68539ffffff6c c6853affffff6f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   89854cffffff         | mov                 dword ptr [ebp - 0xb4], eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c68538ffffff43       | mov                 byte ptr [ebp - 0xc8], 0x43
            //   c68539ffffff6c       | mov                 byte ptr [ebp - 0xc7], 0x6c
            //   c6853affffff6f       | mov                 byte ptr [ebp - 0xc6], 0x6f

        $sequence_8 = { c6852dffffff69 c6852effffff76 c6852fffffff69 c68530ffffff6c c68531ffffff65 c68532ffffff67 c68533ffffff65 }
            // n = 7, score = 100
            //   c6852dffffff69       | mov                 byte ptr [ebp - 0xd3], 0x69
            //   c6852effffff76       | mov                 byte ptr [ebp - 0xd2], 0x76
            //   c6852fffffff69       | mov                 byte ptr [ebp - 0xd1], 0x69
            //   c68530ffffff6c       | mov                 byte ptr [ebp - 0xd0], 0x6c
            //   c68531ffffff65       | mov                 byte ptr [ebp - 0xcf], 0x65
            //   c68532ffffff67       | mov                 byte ptr [ebp - 0xce], 0x67
            //   c68533ffffff65       | mov                 byte ptr [ebp - 0xcd], 0x65

        $sequence_9 = { c645eb00 c645ec65 c645ed00 c645ee6c }
            // n = 4, score = 100
            //   c645eb00             | mov                 byte ptr [ebp - 0x15], 0
            //   c645ec65             | mov                 byte ptr [ebp - 0x14], 0x65
            //   c645ed00             | mov                 byte ptr [ebp - 0x13], 0
            //   c645ee6c             | mov                 byte ptr [ebp - 0x12], 0x6c

    condition:
        7 of them and filesize < 33792
}