rule win_campoloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.campoloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.campoloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec1c a1???????? 33c5 8945fc a1???????? 8945e4 }
            // n = 6, score = 200
            //   83ec1c               | sub                 esp, 0x1c
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   a1????????           |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax

        $sequence_1 = { 898d58efffff c78584efffff00000000 8d55f4 52 8b8558efffff 50 }
            // n = 6, score = 200
            //   898d58efffff         | mov                 dword ptr [ebp - 0x10a8], ecx
            //   c78584efffff00000000     | mov    dword ptr [ebp - 0x107c], 0
            //   8d55f4               | lea                 edx, [ebp - 0xc]
            //   52                   | push                edx
            //   8b8558efffff         | mov                 eax, dword ptr [ebp - 0x10a8]
            //   50                   | push                eax

        $sequence_2 = { ff15???????? ff15???????? 8b8584efffff 8b4dfc 33cd e8???????? }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   8b8584efffff         | mov                 eax, dword ptr [ebp - 0x107c]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     

        $sequence_3 = { 8b9584efffff 039574efffff c60200 8b450c }
            // n = 4, score = 200
            //   8b9584efffff         | mov                 edx, dword ptr [ebp - 0x107c]
            //   039574efffff         | add                 edx, dword ptr [ebp - 0x108c]
            //   c60200               | mov                 byte ptr [edx], 0
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_4 = { ff15???????? 898550efffff 0fb78554efffff 50 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   898550efffff         | mov                 dword ptr [ebp - 0x10b0], eax
            //   0fb78554efffff       | movzx               eax, word ptr [ebp - 0x10ac]
            //   50                   | push                eax

        $sequence_5 = { 038d8cefffff 898d74efffff e9???????? 8b9584efffff 039574efffff c60200 8b450c }
            // n = 7, score = 200
            //   038d8cefffff         | add                 ecx, dword ptr [ebp - 0x1074]
            //   898d74efffff         | mov                 dword ptr [ebp - 0x108c], ecx
            //   e9????????           |                     
            //   8b9584efffff         | mov                 edx, dword ptr [ebp - 0x107c]
            //   039574efffff         | add                 edx, dword ptr [ebp - 0x108c]
            //   c60200               | mov                 byte ptr [edx], 0
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_6 = { ff15???????? 8945f8 68???????? 8b45fc 50 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   68????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax

        $sequence_7 = { 6a01 6a00 6a00 6800000040 8b4510 }
            // n = 5, score = 200
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000040           | push                0x40000000
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_8 = { 8b8558efffff 50 8d8df0feffff 51 }
            // n = 4, score = 200
            //   8b8558efffff         | mov                 eax, dword ptr [ebp - 0x10a8]
            //   50                   | push                eax
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]
            //   51                   | push                ecx

        $sequence_9 = { 8b8d70efffff 51 8b9584efffff 52 ff15???????? }
            // n = 5, score = 200
            //   8b8d70efffff         | mov                 ecx, dword ptr [ebp - 0x1090]
            //   51                   | push                ecx
            //   8b9584efffff         | mov                 edx, dword ptr [ebp - 0x107c]
            //   52                   | push                edx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 66560
}