rule win_carrotbat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.carrotbat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.carrotbat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bce c1f905 8b0c8d20ee4000 83e61f c1e606 89040e 8b45f8 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d20ee4000       | mov                 ecx, dword ptr [ecx*4 + 0x40ee20]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   89040e               | mov                 dword ptr [esi + ecx], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_1 = { 8945fc 6804010000 8d85f8feffff 50 6a00 ff15???????? 33c0 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   6804010000           | push                0x104
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 3008 8b06 8bc8 c1f905 8b0c8d20ee4000 }
            // n = 5, score = 100
            //   3008                 | xor                 byte ptr [eax], cl
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d20ee4000       | mov                 ecx, dword ptr [ecx*4 + 0x40ee20]

        $sequence_3 = { 8bc6 c1f805 8d148520ee4000 8b0a 83e61f }
            // n = 5, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8d148520ee4000       | lea                 edx, [eax*4 + 0x40ee20]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   83e61f               | and                 esi, 0x1f

        $sequence_4 = { 8974241c 5f 660fbef9 66f7d7 66f7d7 c744241480000000 66f7d7 }
            // n = 7, score = 100
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi
            //   5f                   | pop                 edi
            //   660fbef9             | movsx               di, cl
            //   66f7d7               | not                 di
            //   66f7d7               | not                 di
            //   c744241480000000     | mov                 dword ptr [esp + 0x14], 0x80
            //   66f7d7               | not                 di

        $sequence_5 = { c60000 8d85f4fdffff 6a5c 50 }
            // n = 4, score = 100
            //   c60000               | mov                 byte ptr [eax], 0
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   6a5c                 | push                0x5c
            //   50                   | push                eax

        $sequence_6 = { f5 0f88d7feffff d2df 660fa5cf }
            // n = 4, score = 100
            //   f5                   | cmc                 
            //   0f88d7feffff         | js                  0xfffffedd
            //   d2df                 | rcr                 bh, cl
            //   660fa5cf             | shld                di, cx, cl

        $sequence_7 = { ff35???????? 8f442420 66c7442404beba 66c7442408844e e8???????? 8d642418 e8???????? }
            // n = 7, score = 100
            //   ff35????????         |                     
            //   8f442420             | pop                 dword ptr [esp + 0x20]
            //   66c7442404beba       | mov                 word ptr [esp + 4], 0xbabe
            //   66c7442408844e       | mov                 word ptr [esp + 8], 0x4e84
            //   e8????????           |                     
            //   8d642418             | lea                 esp, [esp + 0x18]
            //   e8????????           |                     

        $sequence_8 = { 53 660fb6cb 893424 0fc9 f6d5 9c ff3424 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   660fb6cb             | movzx               cx, bl
            //   893424               | mov                 dword ptr [esp], esi
            //   0fc9                 | bswap               ecx
            //   f6d5                 | not                 ch
            //   9c                   | pushfd              
            //   ff3424               | push                dword ptr [esp]

        $sequence_9 = { 897de4 8bc7 c1f805 8bcf 83e11f c1e106 8b048520ee4000 }
            // n = 7, score = 100
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   8bc7                 | mov                 eax, edi
            //   c1f805               | sar                 eax, 5
            //   8bcf                 | mov                 ecx, edi
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   8b048520ee4000       | mov                 eax, dword ptr [eax*4 + 0x40ee20]

    condition:
        7 of them and filesize < 360448
}