rule win_ccleaner_backdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ccleaner_backdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ccleaner_backdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 ffd6 50 ff15???????? 8b3d???????? 59 ffd7 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   59                   | pop                 ecx
            //   ffd7                 | call                edi

        $sequence_1 = { 750a b857000780 e9???????? e8???????? }
            // n = 4, score = 200
            //   750a                 | jne                 0xc
            //   b857000780           | mov                 eax, 0x80070057
            //   e9????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 6a10 50 c785fcfdffff1c7bae7b c78500feffff5c5aae93 }
            // n = 4, score = 100
            //   6a10                 | push                0x10
            //   50                   | push                eax
            //   c785fcfdffff1c7bae7b     | mov    dword ptr [ebp - 0x204], 0x7bae7b1c
            //   c78500feffff5c5aae93     | mov    dword ptr [ebp - 0x200], 0x93ae5a5c

        $sequence_3 = { 00cc cc 4883ec28 488b11 }
            // n = 4, score = 100
            //   00cc                 | add                 ah, cl
            //   cc                   | int3                
            //   4883ec28             | inc                 eax
            //   488b11               | push                edi

        $sequence_4 = { eb03 8b5d0c 8a41fe 83e003 }
            // n = 4, score = 100
            //   eb03                 | mov                 edx, dword ptr [ebx + 0x40]
            //   8b5d0c               | add                 eax, esi
            //   8a41fe               | test                eax, eax
            //   83e003               | jg                  0xd

        $sequence_5 = { 013d???????? 8b04b5d8970210 0500080000 3bc8 }
            // n = 4, score = 100
            //   013d????????         |                     
            //   8b04b5d8970210       | pop                 ecx
            //   0500080000           | push                edi
            //   3bc8                 | call                esi

        $sequence_6 = { 01cc cc 48895c2408 57 }
            // n = 4, score = 100
            //   01cc                 | lock xadd           dword ptr [edx + 0x10], eax
            //   cc                   | add                 dword ptr [esi + 0xc], eax
            //   48895c2408           | dec                 eax
            //   57                   | mov                 edi, dword ptr [edi]

        $sequence_7 = { c746182cc60210 eb28 83f8fc 7426 }
            // n = 4, score = 100
            //   c746182cc60210       | dec                 esp
            //   eb28                 | lea                 ecx, [edx + edx]
            //   83f8fc               | dec                 esp
            //   7426                 | lea                 eax, [edi + 0x18]

        $sequence_8 = { 01442418 03c8 8954242c 8b542470 }
            // n = 4, score = 100
            //   01442418             | mov                 dword ptr [edi + 0x20], eax
            //   03c8                 | dec                 eax
            //   8954242c             | cmp                 eax, 8
            //   8b542470             | jl                  0xfffffef3

        $sequence_9 = { 48 83f808 0f8ceafeffff eb12 }
            // n = 4, score = 100
            //   48                   | dec                 eax
            //   83f808               | mov                 eax, dword ptr [ecx]
            //   0f8ceafeffff         | call                dword ptr [eax + 8]
            //   eb12                 | dec                 eax

        $sequence_10 = { 01442424 eb30 8b4508 897518 }
            // n = 4, score = 100
            //   01442424             | xor                 eax, eax
            //   eb30                 | pop                 edi
            //   8b4508               | pop                 esi
            //   897518               | pop                 ebp

        $sequence_11 = { 01461c 8b542424 85d2 7405 }
            // n = 4, score = 100
            //   01461c               | add                 dword ptr [esi], edi
            //   8b542424             | xor                 eax, eax
            //   85d2                 | mov                 edx, dword ptr [esi]
            //   7405                 | add                 esp, 0x10

        $sequence_12 = { 00cc cc 4057 4883ec50 4533db }
            // n = 5, score = 100
            //   00cc                 | add                 ah, cl
            //   cc                   | int3                
            //   4057                 | inc                 eax
            //   4883ec50             | push                edi
            //   4533db               | dec                 eax

        $sequence_13 = { c70609000000 c7471870b30210 8b4508 894620 8b450c 89461c 8b45fc }
            // n = 7, score = 100
            //   c70609000000         | dec                 eax
            //   c7471870b30210       | add                 edx, edx
            //   8b4508               | dec                 eax
            //   894620               | lea                 ecx, [ebx + 0x18]
            //   8b450c               | add                 eax, esi
            //   89461c               | test                eax, eax
            //   8b45fc               | jg                  0xd

        $sequence_14 = { ff75e8 8bf8 e8???????? 59 ff75fc ff15???????? }
            // n = 6, score = 100
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     

        $sequence_15 = { 03c0 894340 8b7340 418bc4 }
            // n = 4, score = 100
            //   03c0                 | add                 dword ptr [esi + 0xc], eax
            //   894340               | dec                 eax
            //   8b7340               | mov                 edi, dword ptr [edi]
            //   418bc4               | dec                 ecx

        $sequence_16 = { ff15???????? 8b45f0 0500a30200 50 e8???????? 3bfb 59 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0500a30200           | add                 eax, 0x2a300
            //   50                   | push                eax
            //   e8????????           |                     
            //   3bfb                 | cmp                 edi, ebx
            //   59                   | pop                 ecx

        $sequence_17 = { 6af9 2b5510 8b4d14 58 8911 5f 5e }
            // n = 7, score = 100
            //   6af9                 | dec                 eax
            //   2b5510               | mov                 ecx, dword ptr [edx]
            //   8b4d14               | dec                 eax
            //   58                   | mov                 eax, dword ptr [ecx]
            //   8911                 | call                dword ptr [eax + 8]
            //   5f                   | dec                 eax
            //   5e                   | mov                 ecx, dword ptr [ebx + 0x28]

        $sequence_18 = { 01442454 03d1 294c2450 8b4c2410 }
            // n = 4, score = 100
            //   01442454             | cmp                 ecx, eax
            //   03d1                 | jae                 0x26
            //   294c2450             | mov                 eax, dword ptr [esi*4 + 0x100297d8]
            //   8b4c2410             | add                 eax, 0x800

        $sequence_19 = { 6a04 50 8d45d0 6a04 50 8d85d0feffff 50 }
            // n = 7, score = 100
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   50                   | push                eax

        $sequence_20 = { 837dfc02 0f877b010000 c1e802 8d4c40fd }
            // n = 4, score = 100
            //   837dfc02             | cmp                 dword ptr [ebp - 4], 2
            //   0f877b010000         | ja                  0x181
            //   c1e802               | shr                 eax, 2
            //   8d4c40fd             | lea                 ecx, [eax + eax*2 - 3]

        $sequence_21 = { 48 8bce 49 8d4002 48 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   8bce                 | mov                 ecx, dword ptr [edx]
            //   49                   | dec                 eax
            //   8d4002               | mov                 eax, dword ptr [ecx]
            //   48                   | call                dword ptr [eax + 8]

        $sequence_22 = { 03c6 85c0 7f09 488b0a 488b01 ff5008 488b4b28 }
            // n = 7, score = 100
            //   03c6                 | mov                 eax, esp
            //   85c0                 | add                 eax, eax
            //   7f09                 | mov                 dword ptr [ebx + 0x40], eax
            //   488b0a               | mov                 esi, dword ptr [ebx + 0x40]
            //   488b01               | inc                 ecx
            //   ff5008               | mov                 eax, esp
            //   488b4b28             | dec                 eax

        $sequence_23 = { 6a14 50 c745e01d3b395c c745e4aeacefc4 c745e885230f62 c745ec45a5940f }
            // n = 6, score = 100
            //   6a14                 | push                0x14
            //   50                   | push                eax
            //   c745e01d3b395c       | mov                 dword ptr [ebp - 0x20], 0x5c393b1d
            //   c745e4aeacefc4       | mov                 dword ptr [ebp - 0x1c], 0xc4efacae
            //   c745e885230f62       | mov                 dword ptr [ebp - 0x18], 0x620f2385
            //   c745ec45a5940f       | mov                 dword ptr [ebp - 0x14], 0xf94a545

        $sequence_24 = { 7411 8b5204 85d2 740a 833900 7405 833a00 }
            // n = 7, score = 100
            //   7411                 | je                  0x13
            //   8b5204               | mov                 edx, dword ptr [edx + 4]
            //   85d2                 | test                edx, edx
            //   740a                 | je                  0xc
            //   833900               | cmp                 dword ptr [ecx], 0
            //   7405                 | je                  7
            //   833a00               | cmp                 dword ptr [edx], 0

        $sequence_25 = { 013e 33c0 8b16 83c410 }
            // n = 4, score = 100
            //   013e                 | mov                 dword ptr [esi + 0x18], 0x1002c62c
            //   33c0                 | jmp                 0x2a
            //   8b16                 | cmp                 eax, -4
            //   83c410               | je                  0x2d

        $sequence_26 = { 03c6 4863d0 4c8d0c12 4c8d4718 }
            // n = 4, score = 100
            //   03c6                 | int3                
            //   4863d0               | dec                 eax
            //   4c8d0c12             | mov                 dword ptr [esp + 8], ebx
            //   4c8d4718             | push                edi

        $sequence_27 = { 01460c 488b3f 493bfc 0f8554ffffff }
            // n = 4, score = 100
            //   01460c               | dec                 eax
            //   488b3f               | mov                 edx, dword ptr [ecx]
            //   493bfc               | dec                 eax
            //   0f8554ffffff         | sub                 edx, 0x18

        $sequence_28 = { 012e 33c0 5f 5e 5d }
            // n = 5, score = 100
            //   012e                 | dec                 eax
            //   33c0                 | mov                 eax, dword ptr [ecx]
            //   5f                   | call                dword ptr [eax + 8]
            //   5e                   | dec                 eax
            //   5d                   | mov                 edx, dword ptr [ebx + 0x50]

        $sequence_29 = { c70309000000 c746183cb40210 ebc9 8b450c 894720 }
            // n = 5, score = 100
            //   c70309000000         | add                 eax, esi
            //   c746183cb40210       | test                eax, eax
            //   ebc9                 | jg                  0xd
            //   8b450c               | dec                 eax
            //   894720               | mov                 ecx, dword ptr [edx]

    condition:
        7 of them and filesize < 377856
}