rule win_cloudwizard_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cloudwizard."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cloudwizard"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740b c700???????? 897004 eb02 33c0 8945ec 8365fc00 }
            // n = 7, score = 100
            //   740b                 | je                  0xd
            //   c700????????         |                     
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_1 = { d1f8 51 8d844618060000 50 e8???????? bf???????? 8bc7 }
            // n = 7, score = 100
            //   d1f8                 | sar                 eax, 1
            //   51                   | push                ecx
            //   8d844618060000       | lea                 eax, [esi + eax*2 + 0x618]
            //   50                   | push                eax
            //   e8????????           |                     
            //   bf????????           |                     
            //   8bc7                 | mov                 eax, edi

        $sequence_2 = { c645c74d c645c846 c645c95c c645ca7e c645cb49 c645cc5a }
            // n = 6, score = 100
            //   c645c74d             | mov                 byte ptr [ebp - 0x39], 0x4d
            //   c645c846             | mov                 byte ptr [ebp - 0x38], 0x46
            //   c645c95c             | mov                 byte ptr [ebp - 0x37], 0x5c
            //   c645ca7e             | mov                 byte ptr [ebp - 0x36], 0x7e
            //   c645cb49             | mov                 byte ptr [ebp - 0x35], 0x49
            //   c645cc5a             | mov                 byte ptr [ebp - 0x34], 0x5a

        $sequence_3 = { 668945d6 58 6a49 668945d8 58 6a18 668945da }
            // n = 7, score = 100
            //   668945d6             | mov                 word ptr [ebp - 0x2a], ax
            //   58                   | pop                 eax
            //   6a49                 | push                0x49
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   58                   | pop                 eax
            //   6a18                 | push                0x18
            //   668945da             | mov                 word ptr [ebp - 0x26], ax

        $sequence_4 = { 8983240e0000 5b c9 c20400 55 }
            // n = 5, score = 100
            //   8983240e0000         | mov                 dword ptr [ebx + 0xe24], eax
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp

        $sequence_5 = { 663930 75f5 8d45e8 50 }
            // n = 4, score = 100
            //   663930               | cmp                 word ptr [eax], si
            //   75f5                 | jne                 0xfffffff7
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax

        $sequence_6 = { 668945f0 58 668945f2 6a47 58 668945f4 6a46 }
            // n = 7, score = 100
            //   668945f0             | mov                 word ptr [ebp - 0x10], ax
            //   58                   | pop                 eax
            //   668945f2             | mov                 word ptr [ebp - 0xe], ax
            //   6a47                 | push                0x47
            //   58                   | pop                 eax
            //   668945f4             | mov                 word ptr [ebp - 0xc], ax
            //   6a46                 | push                0x46

        $sequence_7 = { 40 40 66833800 75f4 }
            // n = 4, score = 100
            //   40                   | inc                 eax
            //   40                   | inc                 eax
            //   66833800             | cmp                 word ptr [eax], 0
            //   75f4                 | jne                 0xfffffff6

        $sequence_8 = { 7506 56 e8???????? 6860ea0000 ff15???????? 837e3000 }
            // n = 6, score = 100
            //   7506                 | jne                 8
            //   56                   | push                esi
            //   e8????????           |                     
            //   6860ea0000           | push                0xea60
            //   ff15????????         |                     
            //   837e3000             | cmp                 dword ptr [esi + 0x30], 0

        $sequence_9 = { 6685db 75f6 03c0 50 2bca 8d4560 }
            // n = 6, score = 100
            //   6685db               | test                bx, bx
            //   75f6                 | jne                 0xfffffff8
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   2bca                 | sub                 ecx, edx
            //   8d4560               | lea                 eax, [ebp + 0x60]

    condition:
        7 of them and filesize < 134144
}