rule win_cmstar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cmstar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cmstar"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 bb04010000 57 53 }
            // n = 4, score = 800
            //   56                   | push                esi
            //   bb04010000           | mov                 ebx, 0x104
            //   57                   | push                edi
            //   53                   | push                ebx

        $sequence_1 = { 836dfc10 ff75fc 8945e0 8b45dc 83c310 }
            // n = 5, score = 800
            //   836dfc10             | sub                 dword ptr [ebp - 4], 0x10
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   83c310               | add                 ebx, 0x10

        $sequence_2 = { 8bc6 e9???????? 6a10 8d45d0 53 }
            // n = 5, score = 800
            //   8bc6                 | mov                 eax, esi
            //   e9????????           |                     
            //   6a10                 | push                0x10
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   53                   | push                ebx

        $sequence_3 = { ff15???????? 6a03 58 5f 5e 5b c9 }
            // n = 7, score = 800
            //   ff15????????         |                     
            //   6a03                 | push                3
            //   58                   | pop                 eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_4 = { ff15???????? 6a04 e8???????? be00040000 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   6a04                 | push                4
            //   e8????????           |                     
            //   be00040000           | mov                 esi, 0x400

        $sequence_5 = { 7504 6a03 eb0d 803b4d }
            // n = 4, score = 800
            //   7504                 | jne                 6
            //   6a03                 | push                3
            //   eb0d                 | jmp                 0xf
            //   803b4d               | cmp                 byte ptr [ebx], 0x4d

        $sequence_6 = { 8b4dec c1e802 6a04 52 8d0481 50 }
            // n = 6, score = 800
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   c1e802               | shr                 eax, 2
            //   6a04                 | push                4
            //   52                   | push                edx
            //   8d0481               | lea                 eax, [ecx + eax*4]
            //   50                   | push                eax

        $sequence_7 = { ff75e0 ff30 e8???????? 8b4df8 }
            // n = 4, score = 800
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_8 = { bf???????? 8882a8430010 83c9ff 33c0 42 f2ae f7d1 }
            // n = 7, score = 100
            //   bf????????           |                     
            //   8882a8430010         | mov                 byte ptr [edx + 0x100043a8], al
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   42                   | inc                 edx
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_9 = { 85f6 889183420010 8b15???????? 7506 8b35???????? bf???????? 83c9ff }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   889183420010         | mov                 byte ptr [ecx + 0x10004283], dl
            //   8b15????????         |                     
            //   7506                 | jne                 8
            //   8b35????????         |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_10 = { 889c2418050000 f3ab 66ab aa }
            // n = 4, score = 100
            //   889c2418050000       | mov                 byte ptr [esp + 0x518], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_11 = { 8a4601 46 84c0 75e1 83c9ff 33c0 f2ae }
            // n = 7, score = 100
            //   8a4601               | mov                 al, byte ptr [esi + 1]
            //   46                   | inc                 esi
            //   84c0                 | test                al, al
            //   75e1                 | jne                 0xffffffe3
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_12 = { 7422 3cff 741e fec8 8841ff }
            // n = 5, score = 100
            //   7422                 | je                  0x24
            //   3cff                 | cmp                 al, 0xff
            //   741e                 | je                  0x20
            //   fec8                 | dec                 al
            //   8841ff               | mov                 byte ptr [ecx - 1], al

        $sequence_13 = { 64890d00000000 81c4c0120000 c3 8b8c24d0120000 33db 3bcb 741c }
            // n = 7, score = 100
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   81c4c0120000         | add                 esp, 0x12c0
            //   c3                   | ret                 
            //   8b8c24d0120000       | mov                 ecx, dword ptr [esp + 0x12d0]
            //   33db                 | xor                 ebx, ebx
            //   3bcb                 | cmp                 ecx, ebx
            //   741c                 | je                  0x1e

        $sequence_14 = { ffd5 68???????? 53 ffd5 8bd0 83c9ff }
            // n = 6, score = 100
            //   ffd5                 | call                ebp
            //   68????????           |                     
            //   53                   | push                ebx
            //   ffd5                 | call                ebp
            //   8bd0                 | mov                 edx, eax
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_15 = { f7d1 49 741e 8a441420 bf???????? 8882a8430010 }
            // n = 6, score = 100
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   741e                 | je                  0x20
            //   8a441420             | mov                 al, byte ptr [esp + edx + 0x20]
            //   bf????????           |                     
            //   8882a8430010         | mov                 byte ptr [edx + 0x100043a8], al

    condition:
        7 of them and filesize < 4268032
}