rule win_cobalt_strike_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cobalt_strike."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cobalt_strike"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? eb0a b801000000 e9???????? }
            // n = 4, score = 2000
            //   e9????????           |                     
            //   eb0a                 | dec                 eax
            //   b801000000           | mov                 edx, dword ptr [esp]
            //   e9????????           |                     

        $sequence_1 = { 3bc7 750d ff15???????? 3d33270000 }
            // n = 4, score = 2000
            //   3bc7                 | dec                 eax
            //   750d                 | mov                 dword ptr [esp + 0x30], eax
            //   ff15????????         |                     
            //   3d33270000           | jmp                 0x6e

        $sequence_2 = { ff30 4f ff15???????? 83c604 8b06 }
            // n = 5, score = 1200
            //   ff30                 | dec                 eax
            //   4f                   | arpl                word ptr [eax + 0x3c], ax
            //   ff15????????         |                     
            //   83c604               | dec                 eax
            //   8b06                 | mov                 dword ptr [esp + 0x28], eax

        $sequence_3 = { ff30 8b35???????? e8???????? eb17 }
            // n = 4, score = 1200
            //   ff30                 | push                edi
            //   8b35????????         |                     
            //   e8????????           |                     
            //   eb17                 | push                dword ptr [ebp - 4]

        $sequence_4 = { eb0b 391f 7504 83670400 8b7f20 85ff 75f1 }
            // n = 7, score = 1200
            //   eb0b                 | add                 esi, 4
            //   391f                 | mov                 eax, dword ptr [esi]
            //   7504                 | pop                 ecx
            //   83670400             | test                edi, edi
            //   8b7f20               | jmp                 0xd
            //   85ff                 | mov                 eax, dword ptr [ebp - 0x2c]
            //   75f1                 | add                 eax, 0x10

        $sequence_5 = { eb0b 8b45d4 83c010 8945d4 eb84 e9???????? }
            // n = 6, score = 1200
            //   eb0b                 | dec                 eax
            //   8b45d4               | mov                 dword ptr [esp + 0x28], eax
            //   83c010               | cmp                 eax, edi
            //   8945d4               | jne                 0xf
            //   eb84                 | cmp                 eax, 0x2733
            //   e9????????           |                     

        $sequence_6 = { e8???????? 8bf8 59 59 85ff 7408 ff36 }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   8bf8                 | movzx               edx, word ptr [edx]
            //   59                   | and                 dx, cx
            //   59                   | movzx               ecx, dx
            //   85ff                 | movzx               ecx, cx
            //   7408                 | dec                 eax
            //   ff36                 | mov                 edx, dword ptr [esp + 8]

        $sequence_7 = { e8???????? ff75fc ff15???????? 03fe 2bf8 57 ff75fc }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   ff75fc               | add                 esi, 4
            //   ff15????????         |                     
            //   03fe                 | mov                 eax, dword ptr [esi]
            //   2bf8                 | push                dword ptr [eax]
            //   57                   | dec                 edi
            //   ff75fc               | add                 esi, 4

        $sequence_8 = { ff15???????? 85c0 741d ff15???????? 85c0 }
            // n = 5, score = 1100
            //   ff15????????         |                     
            //   85c0                 | jmp                 0x1d
            //   741d                 | mov                 eax, dword ptr [ebp - 0x10f4]
            //   ff15????????         |                     
            //   85c0                 | add                 eax, 1

        $sequence_9 = { e9???????? 833d????????01 7505 e8???????? }
            // n = 4, score = 1000
            //   e9????????           |                     
            //   833d????????01       |                     
            //   7505                 | cmp                 eax, 0x2733
            //   e8????????           |                     

        $sequence_10 = { 85c0 7405 e8???????? 8b0d???????? 85c9 }
            // n = 5, score = 1000
            //   85c0                 | cmp                 eax, edi
            //   7405                 | jne                 0xf
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   85c9                 | cmp                 eax, 0x2733

        $sequence_11 = { 8bd0 e8???????? 85c0 7e0e }
            // n = 4, score = 1000
            //   8bd0                 | push                dword ptr [edi + 0x1c]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7e0e                 | jne                 0x4c

        $sequence_12 = { ffc3 413bdf 7cde 488b742428 8b85f0170000 }
            // n = 5, score = 800
            //   ffc3                 | je                  0x1f
            //   413bdf               | test                eax, eax
            //   7cde                 | je                  0x1f
            //   488b742428           | test                eax, eax
            //   8b85f0170000         | jne                 0x17

        $sequence_13 = { 81fe00000008 7607 e8???????? eb08 448bce e8???????? 8bd8 }
            // n = 7, score = 800
            //   81fe00000008         | je                  7
            //   7607                 | test                ecx, ecx
            //   e8????????           |                     
            //   eb08                 | test                eax, eax
            //   448bce               | je                  7
            //   e8????????           |                     
            //   8bd8                 | test                ecx, ecx

        $sequence_14 = { e8???????? 85c0 743d ffc3 83fb20 }
            // n = 5, score = 800
            //   e8????????           |                     
            //   85c0                 | mov                 edx, eax
            //   743d                 | test                eax, eax
            //   ffc3                 | jle                 0x12
            //   83fb20               | test                eax, eax

        $sequence_15 = { c744242003000000 ff15???????? 488903 4883f8ff 74b2 8364246000 }
            // n = 6, score = 800
            //   c744242003000000     | je                  0x1f
            //   ff15????????         |                     
            //   488903               | test                eax, eax
            //   4883f8ff             | test                eax, eax
            //   74b2                 | je                  0x1f
            //   8364246000           | test                eax, eax

        $sequence_16 = { 817c2404fca45307 751d 488b442418 8b00 }
            // n = 4, score = 300
            //   817c2404fca45307     | mov                 byte ptr [esp + 0x64], 0x78
            //   751d                 | mov                 byte ptr [esp + 0x65], 0x41
            //   488b442418           | mov                 byte ptr [esp + 0x66], 0
            //   8b00                 | mov                 byte ptr [esp + 0x48], 0x56

        $sequence_17 = { 8b442450 4c8d4c2420 41b820000000 8bd0 488b4c2448 488b442440 }
            // n = 6, score = 300
            //   8b442450             | cmp                 dword ptr [esp + 4], 0x753a4fc
            //   4c8d4c2420           | jne                 0x1f
            //   41b820000000         | dec                 eax
            //   8bd0                 | mov                 eax, dword ptr [esp + 0x18]
            //   488b4c2448           | mov                 eax, dword ptr [eax]
            //   488b442440           | mov                 eax, dword ptr [esp + 0x50]

        $sequence_18 = { 8b4038 488b4c2430 482bc8 488bc1 4889442430 eb5c }
            // n = 6, score = 300
            //   8b4038               | dec                 eax
            //   488b4c2430           | mov                 eax, dword ptr [esp + 0x40]
            //   482bc8               | dec                 eax
            //   488bc1               | lea                 eax, [ecx + eax*4]
            //   4889442430           | dec                 eax
            //   eb5c                 | mov                 dword ptr [esp + 0x48], eax

        $sequence_19 = { c644246345 c644246478 c644246541 c644246600 c644244856 }
            // n = 5, score = 300
            //   c644246345           | mov                 dword ptr [esp], eax
            //   c644246478           | dec                 eax
            //   c644246541           | mov                 eax, dword ptr [esp + 0x58]
            //   c644246600           | movzx               eax, word ptr [eax + 6]
            //   c644244856           | mov                 byte ptr [esp + 0x63], 0x45

        $sequence_20 = { 4863403c 4889442428 48837c242840 722f 48817c242800040000 7324 }
            // n = 6, score = 300
            //   4863403c             | add                 ecx, eax
            //   4889442428           | dec                 eax
            //   48837c242840         | mov                 eax, ecx
            //   722f                 | mov                 eax, dword ptr [eax + 0x38]
            //   48817c242800040000     | dec    eax
            //   7324                 | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_21 = { 488d0481 4889442448 488b442448 8b00 488b8c2498000000 4803c8 488bc1 }
            // n = 7, score = 300
            //   488d0481             | dec                 esp
            //   4889442448           | lea                 ecx, [esp + 0x20]
            //   488b442448           | inc                 ecx
            //   8b00                 | mov                 eax, 0x20
            //   488b8c2498000000     | mov                 edx, eax
            //   4803c8               | dec                 eax
            //   488bc1               | mov                 ecx, dword ptr [esp + 0x48]

        $sequence_22 = { 488b4c2458 488d440118 48890424 488b442458 0fb74006 }
            // n = 5, score = 300
            //   488b4c2458           | dec                 eax
            //   488d440118           | mov                 ecx, dword ptr [esp + 0x58]
            //   48890424             | dec                 eax
            //   488b442458           | lea                 eax, [ecx + eax + 0x18]
            //   0fb74006             | dec                 eax

        $sequence_23 = { 488b1424 0fb712 6623d1 0fb7ca 0fb7c9 488b542408 }
            // n = 6, score = 300
            //   488b1424             | dec                 eax
            //   0fb712               | mov                 eax, dword ptr [esp + 0x48]
            //   6623d1               | mov                 eax, dword ptr [eax]
            //   0fb7ca               | dec                 eax
            //   0fb7c9               | mov                 ecx, dword ptr [esp + 0x98]
            //   488b542408           | dec                 eax

    condition:
        7 of them and filesize < 1015808
}