rule win_cobint_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cobint."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cobint"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b15???????? a1???????? 03d2 8b4d14 894cd00c a1???????? }
            // n = 6, score = 400
            //   8b15????????         |                     
            //   a1????????           |                     
            //   03d2                 | add                 edx, edx
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   894cd00c             | mov                 dword ptr [eax + edx*8 + 0xc], ecx
            //   a1????????           |                     

        $sequence_1 = { 33f6 a3???????? 56 50 e8???????? 83c410 8935???????? }
            // n = 7, score = 400
            //   33f6                 | xor                 esi, esi
            //   a3????????           |                     
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8935????????         |                     

        $sequence_2 = { 59 3bc7 7408 33ff 57 }
            // n = 5, score = 400
            //   59                   | pop                 ecx
            //   3bc7                 | cmp                 eax, edi
            //   7408                 | je                  0xa
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi

        $sequence_3 = { 8945e8 85c0 7470 2175fc }
            // n = 4, score = 400
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   85c0                 | test                eax, eax
            //   7470                 | je                  0x72
            //   2175fc               | and                 dword ptr [ebp - 4], esi

        $sequence_4 = { 890b 8b4508 8945e8 85c0 }
            // n = 4, score = 400
            //   890b                 | mov                 dword ptr [ebx], ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   85c0                 | test                eax, eax

        $sequence_5 = { 43 3bd8 0f8c59ffffff ff75fc ff15???????? 8bc7 }
            // n = 6, score = 400
            //   43                   | inc                 ebx
            //   3bd8                 | cmp                 ebx, eax
            //   0f8c59ffffff         | jl                  0xffffff5f
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   8bc7                 | mov                 eax, edi

        $sequence_6 = { 8b7508 880e 8b4d10 49 51 }
            // n = 5, score = 400
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   880e                 | mov                 byte ptr [esi], cl
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   49                   | dec                 ecx
            //   51                   | push                ecx

        $sequence_7 = { 8bec 56 57 8b7d08 33f6 a1???????? 03c6 }
            // n = 7, score = 400
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   a1????????           |                     
            //   03c6                 | add                 eax, esi

        $sequence_8 = { 8b75e4 53 ffd6 eb03 8b75e4 ff75d8 ffd6 }
            // n = 7, score = 200
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   eb03                 | jmp                 5
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   ffd6                 | call                esi

        $sequence_9 = { 740a 33c0 8b12 85d2 75c4 eb03 }
            // n = 6, score = 200
            //   740a                 | je                  0xc
            //   33c0                 | xor                 eax, eax
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   85d2                 | test                edx, edx
            //   75c4                 | jne                 0xffffffc6
            //   eb03                 | jmp                 5

        $sequence_10 = { 0355f0 8a45ec 8802 eb0b 8b4d08 034df0 8a55ed }
            // n = 7, score = 200
            //   0355f0               | add                 edx, dword ptr [ebp - 0x10]
            //   8a45ec               | mov                 al, byte ptr [ebp - 0x14]
            //   8802                 | mov                 byte ptr [edx], al
            //   eb0b                 | jmp                 0xd
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]
            //   8a55ed               | mov                 dl, byte ptr [ebp - 0x13]

        $sequence_11 = { 51 51 51 8d8d24feffff 51 ffd0 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8d8d24feffff         | lea                 ecx, [ebp - 0x1dc]
            //   51                   | push                ecx
            //   ffd0                 | call                eax

        $sequence_12 = { 8d981b040000 64a130000000 895df4 8b400c 8b5014 }
            // n = 5, score = 200
            //   8d981b040000         | lea                 ebx, [eax + 0x41b]
            //   64a130000000         | mov                 eax, dword ptr fs:[0x30]
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b5014               | mov                 edx, dword ptr [eax + 0x14]

        $sequence_13 = { 90 90 90 90 90 749b }
            // n = 6, score = 200
            //   90                   | nop                 
            //   90                   | nop                 
            //   90                   | nop                 
            //   90                   | nop                 
            //   90                   | nop                 
            //   749b                 | je                  0xffffff9d

        $sequence_14 = { 90 749b 807ce19a80 7c90 }
            // n = 4, score = 200
            //   90                   | nop                 
            //   749b                 | je                  0xffffff9d
            //   807ce19a80           | cmp                 byte ptr [ecx - 0x66], 0x80
            //   7c90                 | jl                  0xffffff92

        $sequence_15 = { 90 e10b 96 7c90 90 90 }
            // n = 6, score = 200
            //   90                   | nop                 
            //   e10b                 | loope               0xd
            //   96                   | xchg                eax, esi
            //   7c90                 | jl                  0xffffff92
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_16 = { 837dec00 7418 037dec 8d45ec 50 }
            // n = 5, score = 200
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   7418                 | je                  0x1a
            //   037dec               | add                 edi, dword ptr [ebp - 0x14]
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

        $sequence_17 = { 885dff 8d45d0 c745d090010000 50 8d8524feffff }
            // n = 5, score = 200
            //   885dff               | mov                 byte ptr [ebp - 1], bl
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   c745d090010000       | mov                 dword ptr [ebp - 0x30], 0x190
            //   50                   | push                eax
            //   8d8524feffff         | lea                 eax, [ebp - 0x1dc]

        $sequence_18 = { 90 90 bffc807c28 1a807c170e81 7cd7 }
            // n = 5, score = 200
            //   90                   | nop                 
            //   90                   | nop                 
            //   bffc807c28           | mov                 edi, 0x287c80fc
            //   1a807c170e81         | sbb                 al, byte ptr [eax - 0x7ef1e884]
            //   7cd7                 | jl                  0xffffffd9

        $sequence_19 = { 8d45e8 2bdf 50 56 6a01 53 8d0437 }
            // n = 7, score = 200
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   2bdf                 | sub                 ebx, edi
            //   50                   | push                eax
            //   56                   | push                esi
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   8d0437               | lea                 eax, [edi + esi]

        $sequence_20 = { 83c005 c3 31b7807c30ae 807c909090 }
            // n = 4, score = 200
            //   83c005               | add                 eax, 5
            //   c3                   | ret                 
            //   31b7807c30ae         | xor                 dword ptr [edi - 0x51cf8380], esi
            //   807c909090           | cmp                 byte ptr [eax + edx*4 - 0x70], 0x90

        $sequence_21 = { 749b 807ce19a80 7c90 90 90 90 }
            // n = 6, score = 200
            //   749b                 | je                  0xffffff9d
            //   807ce19a80           | cmp                 byte ptr [ecx - 0x66], 0x80
            //   7c90                 | jl                  0xffffff92
            //   90                   | nop                 
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_22 = { 51 6800008000 51 51 51 8d8524feffff 50 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   6800008000           | push                0x800000
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8d8524feffff         | lea                 eax, [ebp - 0x1dc]
            //   50                   | push                eax

        $sequence_23 = { bffc807c28 1a807c170e81 7cd7 9b 807c909090 90 }
            // n = 6, score = 200
            //   bffc807c28           | mov                 edi, 0x287c80fc
            //   1a807c170e81         | sbb                 al, byte ptr [eax - 0x7ef1e884]
            //   7cd7                 | jl                  0xffffffd9
            //   9b                   | wait                
            //   807c909090           | cmp                 byte ptr [eax + edx*4 - 0x70], 0x90
            //   90                   | nop                 

    condition:
        7 of them and filesize < 65536
}