rule win_collectorgoomba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.collectorgoomba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.collectorgoomba"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7508 e8???????? 59 59 8845ff 8d4df4 e8???????? }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8845ff               | mov                 byte ptr [ebp - 1], al
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   e8????????           |                     

        $sequence_1 = { ff55d8 83c40c 8b4508 0fb700 25ff000000 8845fd 8b450c }
            // n = 7, score = 200
            //   ff55d8               | call                dword ptr [ebp - 0x28]
            //   83c40c               | add                 esp, 0xc
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb700               | movzx               eax, word ptr [eax]
            //   25ff000000           | and                 eax, 0xff
            //   8845fd               | mov                 byte ptr [ebp - 3], al
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_2 = { ff55b0 83c40c 8b4508 8b4008 c1e810 25ff000000 8845f8 }
            // n = 7, score = 200
            //   ff55b0               | call                dword ptr [ebp - 0x50]
            //   83c40c               | add                 esp, 0xc
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   c1e810               | shr                 eax, 0x10
            //   25ff000000           | and                 eax, 0xff
            //   8845f8               | mov                 byte ptr [ebp - 8], al

        $sequence_3 = { 8d8528ffffff 50 e8???????? 83c410 8bf0 8dbd48ffffff a5 }
            // n = 7, score = 200
            //   8d8528ffffff         | lea                 eax, [ebp - 0xd8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8bf0                 | mov                 esi, eax
            //   8dbd48ffffff         | lea                 edi, [ebp - 0xb8]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_4 = { ff7510 8d4de0 e8???????? 8365fc00 eb09 8b45f0 83c018 }
            // n = 7, score = 200
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   eb09                 | jmp                 0xb
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83c018               | add                 eax, 0x18

        $sequence_5 = { c705????????01020303 c705????????0104040e 833d????????00 740a c705????????0b060a0f c705????????08060301 c705????????040f0608 }
            // n = 7, score = 200
            //   c705????????01020303     |     
            //   c705????????0104040e     |     
            //   833d????????00       |                     
            //   740a                 | je                  0xc
            //   c705????????0b060a0f     |     
            //   c705????????08060301     |     
            //   c705????????040f0608     |     

        $sequence_6 = { 8b4508 0fb7401c 83c860 8b4d08 6689411c 8b4508 8b4dec }
            // n = 7, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb7401c             | movzx               eax, word ptr [eax + 0x1c]
            //   83c860               | or                  eax, 0x60
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   6689411c             | mov                 word ptr [ecx + 0x1c], ax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

        $sequence_7 = { c705????????050f0f07 c705????????0c07090d c705????????0b010d0f 833d????????00 740a c705????????090c0001 c705????????0f0d050a }
            // n = 7, score = 200
            //   c705????????050f0f07     |     
            //   c705????????0c07090d     |     
            //   c705????????0b010d0f     |     
            //   833d????????00       |                     
            //   740a                 | je                  0xc
            //   c705????????090c0001     |     
            //   c705????????0f0d050a     |     

        $sequence_8 = { ff75fc 8d45f0 50 e8???????? 83c41c 688e4379a6 6a11 }
            // n = 7, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   688e4379a6           | push                0xa679438e
            //   6a11                 | push                0x11

        $sequence_9 = { ff7040 e8???????? 83c410 8945f8 837df800 7405 e9???????? }
            // n = 7, score = 200
            //   ff7040               | push                dword ptr [eax + 0x40]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7405                 | je                  7
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1400832
}