rule win_combos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.combos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.combos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd8 899dd8feffff 3bdf 0f84a2000000 8b7d0c 83c9ff }
            // n = 6, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   899dd8feffff         | mov                 dword ptr [ebp - 0x128], ebx
            //   3bdf                 | cmp                 ebx, edi
            //   0f84a2000000         | je                  0xa8
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_1 = { 83e33f 33d3 c1f804 8b9c9600030000 8a51ff 0bfb }
            // n = 6, score = 100
            //   83e33f               | and                 ebx, 0x3f
            //   33d3                 | xor                 edx, ebx
            //   c1f804               | sar                 eax, 4
            //   8b9c9600030000       | mov                 ebx, dword ptr [esi + edx*4 + 0x300]
            //   8a51ff               | mov                 dl, byte ptr [ecx - 1]
            //   0bfb                 | or                  edi, ebx

        $sequence_2 = { c1f805 8d1c85201b0110 8b4508 83e01f 8d34c0 }
            // n = 5, score = 100
            //   c1f805               | sar                 eax, 5
            //   8d1c85201b0110       | lea                 ebx, [eax*4 + 0x10011b20]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83e01f               | and                 eax, 0x1f
            //   8d34c0               | lea                 esi, [eax + eax*8]

        $sequence_3 = { 53 56 8b8dd8feffff 51 57 68ffff1f00 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b8dd8feffff         | mov                 ecx, dword ptr [ebp - 0x128]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   68ffff1f00           | push                0x1fffff

        $sequence_4 = { 85db 750b 8d4eff 3bf9 8b4c2410 }
            // n = 5, score = 100
            //   85db                 | test                ebx, ebx
            //   750b                 | jne                 0xd
            //   8d4eff               | lea                 ecx, [esi - 1]
            //   3bf9                 | cmp                 edi, ecx
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_5 = { ff15???????? 8bd0 8995d8feffff 3bd3 0f847d010000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8995d8feffff         | mov                 dword ptr [ebp - 0x128], edx
            //   3bd3                 | cmp                 edx, ebx
            //   0f847d010000         | je                  0x183

        $sequence_6 = { 48 8bf0 c1f803 83e607 0fbe0410 8504b548930010 0f95c0 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8bf0                 | mov                 esi, eax
            //   c1f803               | sar                 eax, 3
            //   83e607               | and                 esi, 7
            //   0fbe0410             | movsx               eax, byte ptr [eax + edx]
            //   8504b548930010       | test                dword ptr [esi*4 + 0x10009348], eax
            //   0f95c0               | setne               al

        $sequence_7 = { 8b0c8d201b0110 8d04c0 f644810401 7425 57 56 e8???????? }
            // n = 7, score = 100
            //   8b0c8d201b0110       | mov                 ecx, dword ptr [ecx*4 + 0x10011b20]
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   f644810401           | test                byte ptr [ecx + eax*4 + 4], 1
            //   7425                 | je                  0x27
            //   57                   | push                edi
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_8 = { 50 56 e8???????? 8945d0 8b7d08 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_9 = { 8bd0 2be8 89542414 eb04 8b542414 33c0 }
            // n = 6, score = 100
            //   8bd0                 | mov                 edx, eax
            //   2be8                 | sub                 ebp, eax
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   eb04                 | jmp                 6
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 163840
}