rule win_compfun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.compfun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.compfun"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 742d 53 8d85d8fdffff 50 a1???????? }
            // n = 5, score = 300
            //   742d                 | je                  0x2f
            //   53                   | push                ebx
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   50                   | push                eax
            //   a1????????           |                     

        $sequence_1 = { c70642434445 c7460430333935 c746082d453532 c7460c462d3436 }
            // n = 4, score = 300
            //   c70642434445         | mov                 dword ptr [esi], 0x45444342
            //   c7460430333935       | mov                 dword ptr [esi + 4], 0x35393330
            //   c746082d453532       | mov                 dword ptr [esi + 8], 0x3235452d
            //   c7460c462d3436       | mov                 dword ptr [esi + 0xc], 0x36342d46

        $sequence_2 = { c746086f6c6865 c7460c6c703332 c74610536e6170 c7461473686f74 c6461800 }
            // n = 5, score = 300
            //   c746086f6c6865       | mov                 dword ptr [esi + 8], 0x65686c6f
            //   c7460c6c703332       | mov                 dword ptr [esi + 0xc], 0x3233706c
            //   c74610536e6170       | mov                 dword ptr [esi + 0x10], 0x70616e53
            //   c7461473686f74       | mov                 dword ptr [esi + 0x14], 0x746f6873
            //   c6461800             | mov                 byte ptr [esi + 0x18], 0

        $sequence_3 = { 85c0 0f848b000000 68???????? e8???????? 59 50 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   0f848b000000         | je                  0x91
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax

        $sequence_4 = { c6460600 8bc6 5e 5d }
            // n = 4, score = 300
            //   c6460600             | mov                 byte ptr [esi + 6], 0
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_5 = { 50 57 ffd3 894604 85c0 7433 68???????? }
            // n = 7, score = 300
            //   50                   | push                eax
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   85c0                 | test                eax, eax
            //   7433                 | je                  0x35
            //   68????????           |                     

        $sequence_6 = { c7460465744d6f c7460864756c65 c7460c46696c65 c746104e616d65 c6461700 }
            // n = 5, score = 300
            //   c7460465744d6f       | mov                 dword ptr [esi + 4], 0x6f4d7465
            //   c7460864756c65       | mov                 dword ptr [esi + 8], 0x656c7564
            //   c7460c46696c65       | mov                 dword ptr [esi + 0xc], 0x656c6946
            //   c746104e616d65       | mov                 dword ptr [esi + 0x10], 0x656d614e
            //   c6461700             | mov                 byte ptr [esi + 0x17], 0

        $sequence_7 = { c70647657456 c7460465727369 c746086f6e4578 c6460d00 8bc6 }
            // n = 5, score = 300
            //   c70647657456         | mov                 dword ptr [esi], 0x56746547
            //   c7460465727369       | mov                 dword ptr [esi + 4], 0x69737265
            //   c746086f6e4578       | mov                 dword ptr [esi + 8], 0x78456e6f
            //   c6460d00             | mov                 byte ptr [esi + 0xd], 0
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 034c2460 488b442450 894820 488b4c2450 }
            // n = 4, score = 100
            //   034c2460             | lea                 edx, [esp + 0x40]
            //   488b442450           | dec                 eax
            //   894820               | mov                 ecx, dword ptr [esp + 0x70]
            //   488b4c2450           | add                 ecx, dword ptr [esp + 0x2c]

        $sequence_9 = { 0344242c 8bc8 e8???????? 4889442448 }
            // n = 4, score = 100
            //   0344242c             | add                 eax, dword ptr [esp + 0x2c]
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   4889442448           | dec                 eax

        $sequence_10 = { 03c1 89442420 8b442420 83c001 }
            // n = 4, score = 100
            //   03c1                 | add                 ecx, dword ptr [esp + 0x60]
            //   89442420             | dec                 eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x50]
            //   83c001               | mov                 dword ptr [eax + 0x20], ecx

        $sequence_11 = { 03c1 89442434 8b442430 39442434 }
            // n = 4, score = 100
            //   03c1                 | mov                 dword ptr [esp + 0x20], eax
            //   89442434             | mov                 eax, dword ptr [esp + 0x20]
            //   8b442430             | add                 eax, 0xa
            //   39442434             | add                 eax, ecx

        $sequence_12 = { 03c1 4863d0 488b4c2430 488b442438 }
            // n = 4, score = 100
            //   03c1                 | add                 ecx, dword ptr [esp + 0x60]
            //   4863d0               | dec                 eax
            //   488b4c2430           | mov                 eax, dword ptr [esp + 0x50]
            //   488b442438           | mov                 dword ptr [eax + 0x20], ecx

        $sequence_13 = { 03c1 89442420 8b4c2438 488b442450 }
            // n = 4, score = 100
            //   03c1                 | dec                 eax
            //   89442420             | mov                 eax, dword ptr [esp + 0x38]
            //   8b4c2438             | inc                 edx
            //   488b442450           | movzx               eax, byte ptr [eax + eax]

        $sequence_14 = { 03c1 89442420 8b542438 486bd218 }
            // n = 4, score = 100
            //   03c1                 | movzx               eax, byte ptr [eax + eax]
            //   89442420             | mov                 byte ptr [ecx + edx], al
            //   8b542438             | mov                 eax, dword ptr [esp + 0x18]
            //   486bd218             | add                 eax, ecx

        $sequence_15 = { 034c242c 488b442470 894820 488d542440 }
            // n = 4, score = 100
            //   034c242c             | add                 eax, dword ptr [esp + 0x2c]
            //   488b442470           | mov                 ecx, eax
            //   894820               | dec                 eax
            //   488d542440           | mov                 dword ptr [esp + 0x48], eax

    condition:
        7 of them and filesize < 402432
}