rule win_coredn_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.coredn."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.coredn"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 56 8d45fc 8bf1 50 e8???????? 85c0 }
            // n = 7, score = 600
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8bf1                 | mov                 esi, ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { 2bf1 6690 8d82fafeff7f 85c0 741c 8a040e 84c0 }
            // n = 7, score = 400
            //   2bf1                 | sub                 esi, ecx
            //   6690                 | nop                 
            //   8d82fafeff7f         | lea                 eax, [edx + 0x7ffffefa]
            //   85c0                 | test                eax, eax
            //   741c                 | je                  0x1e
            //   8a040e               | mov                 al, byte ptr [esi + ecx]
            //   84c0                 | test                al, al

        $sequence_2 = { 57 bf00000000 8d0432 2bca 7438 }
            // n = 5, score = 400
            //   57                   | push                edi
            //   bf00000000           | mov                 edi, 0
            //   8d0432               | lea                 eax, [edx + esi]
            //   2bca                 | sub                 ecx, edx
            //   7438                 | je                  0x3a

        $sequence_3 = { 8851ff b87a000780 5e 5d }
            // n = 4, score = 400
            //   8851ff               | mov                 byte ptr [ecx - 1], dl
            //   b87a000780           | mov                 eax, 0x8007007a
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_4 = { 8a040e 84c0 7415 8801 41 83ea01 }
            // n = 6, score = 400
            //   8a040e               | mov                 al, byte ptr [esi + ecx]
            //   84c0                 | test                al, al
            //   7415                 | je                  0x17
            //   8801                 | mov                 byte ptr [ecx], al
            //   41                   | inc                 ecx
            //   83ea01               | sub                 edx, 1

        $sequence_5 = { 5e 8be5 5d c20400 85c9 7506 48 }
            // n = 7, score = 400
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   85c9                 | test                ecx, ecx
            //   7506                 | jne                 8
            //   48                   | dec                 eax

        $sequence_6 = { 03d1 2bf0 85d2 7423 8a1c06 84db 741c }
            // n = 7, score = 400
            //   03d1                 | add                 edx, ecx
            //   2bf0                 | sub                 esi, eax
            //   85d2                 | test                edx, edx
            //   7423                 | je                  0x25
            //   8a1c06               | mov                 bl, byte ptr [esi + eax]
            //   84db                 | test                bl, bl
            //   741c                 | je                  0x1e

        $sequence_7 = { 84db 741c 8818 4a 40 }
            // n = 5, score = 400
            //   84db                 | test                bl, bl
            //   741c                 | je                  0x1e
            //   8818                 | mov                 byte ptr [eax], bl
            //   4a                   | dec                 edx
            //   40                   | inc                 eax

        $sequence_8 = { 8b0cc5ac1b4100 894de4 85c9 7455 8b4510 8945e8 8b4514 }
            // n = 7, score = 200
            //   8b0cc5ac1b4100       | mov                 ecx, dword ptr [eax*8 + 0x411bac]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   85c9                 | test                ecx, ecx
            //   7455                 | je                  0x57
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_9 = { 83c00c 83e03f 8a80b81c4100 88040a 8b06 }
            // n = 5, score = 200
            //   83c00c               | add                 eax, 0xc
            //   83e03f               | and                 eax, 0x3f
            //   8a80b81c4100         | mov                 al, byte ptr [eax + 0x411cb8]
            //   88040a               | mov                 byte ptr [edx + ecx], al
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_10 = { 8d3c8530404100 8b0f 85c9 740b 8d4101 f7d8 }
            // n = 6, score = 200
            //   8d3c8530404100       | lea                 edi, [eax*4 + 0x414030]
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   85c9                 | test                ecx, ecx
            //   740b                 | je                  0xd
            //   8d4101               | lea                 eax, [ecx + 1]
            //   f7d8                 | neg                 eax

        $sequence_11 = { 83e03f c1ff06 6bd830 8b04bd08414100 f644032801 7444 }
            // n = 6, score = 200
            //   83e03f               | and                 eax, 0x3f
            //   c1ff06               | sar                 edi, 6
            //   6bd830               | imul                ebx, eax, 0x30
            //   8b04bd08414100       | mov                 eax, dword ptr [edi*4 + 0x414108]
            //   f644032801           | test                byte ptr [ebx + eax + 0x28], 1
            //   7444                 | je                  0x46

        $sequence_12 = { 6bc618 57 8db8d83e4100 57 ff15???????? }
            // n = 5, score = 200
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8d83e4100         | lea                 edi, [eax + 0x413ed8]
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_13 = { 8b1c85e8dd4000 56 6800080000 6a00 53 ff15???????? }
            // n = 6, score = 200
            //   8b1c85e8dd4000       | mov                 ebx, dword ptr [eax*4 + 0x40dde8]
            //   56                   | push                esi
            //   6800080000           | push                0x800
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_14 = { 83c40c 6b45e430 8945e0 8d80a8304100 }
            // n = 4, score = 200
            //   83c40c               | add                 esp, 0xc
            //   6b45e430             | imul                eax, dword ptr [ebp - 0x1c], 0x30
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d80a8304100         | lea                 eax, [eax + 0x4130a8]

    condition:
        7 of them and filesize < 270336
}