rule win_cradlecore_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cradlecore."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cradlecore"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7402 2bf8 6aff 6a00 8d45d8 8bce }
            // n = 6, score = 100
            //   7402                 | je                  4
            //   2bf8                 | sub                 edi, eax
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8bce                 | mov                 ecx, esi

        $sequence_1 = { 8b048db8734000 ffe0 f7c703000000 7515 c1e902 83e203 }
            // n = 6, score = 100
            //   8b048db8734000       | mov                 eax, dword ptr [ecx*4 + 0x4073b8]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3
            //   7515                 | jne                 0x17
            //   c1e902               | shr                 ecx, 2
            //   83e203               | and                 edx, 3

        $sequence_2 = { 6a00 ff7508 8b16 ff5238 8ac8 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   ff5238               | call                dword ptr [edx + 0x38]
            //   8ac8                 | mov                 cl, al

        $sequence_3 = { 33f6 46 837de810 8bc1 7303 8d45d4 03c6 }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   46                   | inc                 esi
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   8bc1                 | mov                 eax, ecx
            //   7303                 | jae                 5
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   03c6                 | add                 eax, esi

        $sequence_4 = { 837f1410 894dd8 7204 8b07 eb02 8bc7 803c103d }
            // n = 7, score = 100
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx
            //   7204                 | jb                  6
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi
            //   803c103d             | cmp                 byte ptr [eax + edx], 0x3d

        $sequence_5 = { 0f8f4dffffff 7c08 85f6 0f8543ffffff 8b4c240c 8b542410 5f }
            // n = 7, score = 100
            //   0f8f4dffffff         | jg                  0xffffff53
            //   7c08                 | jl                  0xa
            //   85f6                 | test                esi, esi
            //   0f8543ffffff         | jne                 0xffffff49
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   5f                   | pop                 edi

        $sequence_6 = { ff15???????? 85c0 7514 6a07 8d45d0 50 6a01 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16
            //   6a07                 | push                7
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_7 = { 57 ffd6 6a04 8d4508 c7450803000000 50 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   6a04                 | push                4
            //   8d4508               | lea                 eax, [ebp + 8]
            //   c7450803000000       | mov                 dword ptr [ebp + 8], 3
            //   50                   | push                eax

        $sequence_8 = { e8???????? 395f40 7527 ff7750 885c2413 8d442413 33db }
            // n = 7, score = 100
            //   e8????????           |                     
            //   395f40               | cmp                 dword ptr [edi + 0x40], ebx
            //   7527                 | jne                 0x29
            //   ff7750               | push                dword ptr [edi + 0x50]
            //   885c2413             | mov                 byte ptr [esp + 0x13], bl
            //   8d442413             | lea                 eax, [esp + 0x13]
            //   33db                 | xor                 ebx, ebx

        $sequence_9 = { 894108 8d4d90 c645fc05 e8???????? 6a00 ff7508 8d8d24feffff }
            // n = 7, score = 100
            //   894108               | mov                 dword ptr [ecx + 8], eax
            //   8d4d90               | lea                 ecx, [ebp - 0x70]
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   e8????????           |                     
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d8d24feffff         | lea                 ecx, [ebp - 0x1dc]

    condition:
        7 of them and filesize < 450560
}