rule win_crosswalk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.crosswalk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crosswalk"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 410fbe00 49ffc0 d3ca 03d0 4183ef01 }
            // n = 5, score = 1300
            //   410fbe00             | imul                eax, edx, 0xe89
            //   49ffc0               | cmp                 ecx, eax
            //   d3ca                 | inc                 ecx
            //   03d0                 | movsx               eax, byte ptr [eax]
            //   4183ef01             | dec                 ecx

        $sequence_1 = { 4c8bc6 33d2 410fbe00 49ffc0 }
            // n = 4, score = 1300
            //   4c8bc6               | add                 edx, eax
            //   33d2                 | inc                 ecx
            //   410fbe00             | sub                 edi, 1
            //   49ffc0               | inc                 ecx

        $sequence_2 = { 41b88d56e68c 418bc0 f7e9 03d1 c1fa0b 8bc2 }
            // n = 6, score = 1300
            //   41b88d56e68c         | inc                 ecx
            //   418bc0               | mov                 eax, 0x8ce6568d
            //   f7e9                 | inc                 ecx
            //   03d1                 | mov                 eax, eax
            //   c1fa0b               | imul                ecx
            //   8bc2                 | add                 edx, ecx

        $sequence_3 = { 458d7ee0 418bd7 ff15???????? 4821742420 }
            // n = 4, score = 1300
            //   458d7ee0             | inc                 eax
            //   418bd7               | ror                 edx, cl
            //   ff15????????         |                     
            //   4821742420           | add                 edx, eax

        $sequence_4 = { 4883ec28 4885c9 7402 ffd1 }
            // n = 4, score = 1300
            //   4883ec28             | inc                 eax
            //   4885c9               | ror                 edx, cl
            //   7402                 | add                 edx, eax
            //   ffd1                 | inc                 ecx

        $sequence_5 = { 458bc6 33d2 488bc8 e8???????? 4533c9 }
            // n = 5, score = 1300
            //   458bc6               | inc                 ecx
            //   33d2                 | movsx               eax, byte ptr [eax]
            //   488bc8               | dec                 ecx
            //   e8????????           |                     
            //   4533c9               | inc                 eax

        $sequence_6 = { ff15???????? 448bf0 4533c9 4533c0 }
            // n = 4, score = 1300
            //   ff15????????         |                     
            //   448bf0               | add                 edx, eax
            //   4533c9               | imul                eax, edx, 0xe89
            //   4533c0               | dec                 esp

        $sequence_7 = { c1fa0b 8bc2 c1e81f 03d0 69c2890e0000 }
            // n = 5, score = 1300
            //   c1fa0b               | sar                 edx, 0xb
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03d0                 | add                 edx, eax
            //   69c2890e0000         | imul                eax, edx, 0xe89

        $sequence_8 = { ebc6 c745e0285b4100 e9???????? c745e0305b4100 e9???????? }
            // n = 5, score = 200
            //   ebc6                 | imul                ecx
            //   c745e0285b4100       | add                 edx, ecx
            //   e9????????           |                     
            //   c745e0305b4100       | sar                 edx, 0xb
            //   e9????????           |                     

        $sequence_9 = { 57 8db8948b4100 57 ff15???????? }
            // n = 4, score = 200
            //   57                   | ror                 edx, cl
            //   8db8948b4100         | add                 edx, eax
            //   57                   | inc                 ecx
            //   ff15????????         |                     

        $sequence_10 = { 7313 8a87f4814100 08441619 42 0fb64101 }
            // n = 5, score = 200
            //   7313                 | jne                 0xfffffff9
            //   8a87f4814100         | inc                 ecx
            //   08441619             | movsx               eax, byte ptr [eax]
            //   42                   | dec                 ecx
            //   0fb64101             | inc                 eax

        $sequence_11 = { 8d8008824100 8945e4 803800 8bc8 }
            // n = 4, score = 200
            //   8d8008824100         | ror                 edx, cl
            //   8945e4               | add                 edx, eax
            //   803800               | inc                 ecx
            //   8bc8                 | sub                 edi, 1

        $sequence_12 = { 0f8e6fffffff 83c8ff eb07 8b04cd743f4100 5f }
            // n = 5, score = 200
            //   0f8e6fffffff         | imul                ecx
            //   83c8ff               | add                 edx, ecx
            //   eb07                 | sar                 edx, 0xb
            //   8b04cd743f4100       | dec                 ecx
            //   5f                   | inc                 eax

        $sequence_13 = { 8b4508 dd00 ebc6 c745e0285b4100 }
            // n = 4, score = 200
            //   8b4508               | sub                 edi, 1
            //   dd00                 | jne                 0xfffffffc
            //   ebc6                 | inc                 ecx
            //   c745e0285b4100       | mov                 eax, eax

        $sequence_14 = { eb14 85db 7507 c74634f41a4100 57 ff7634 e8???????? }
            // n = 7, score = 200
            //   eb14                 | mov                 eax, edx
            //   85db                 | inc                 esp
            //   7507                 | mov                 esi, eax
            //   c74634f41a4100       | inc                 ebp
            //   57                   | xor                 ecx, ecx
            //   ff7634               | inc                 ebp
            //   e8????????           |                     

        $sequence_15 = { 83feff 0f8483000000 eb7d 8b1c9d00124100 6800080000 6a00 }
            // n = 6, score = 200
            //   83feff               | mov                 eax, eax
            //   0f8483000000         | imul                ecx
            //   eb7d                 | add                 edx, ecx
            //   8b1c9d00124100       | sar                 edx, 0xb
            //   6800080000           | inc                 ecx
            //   6a00                 | mov                 eax, eax

    condition:
        7 of them and filesize < 286720
}