rule win_crylocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.crylocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crylocker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 53 57 68???????? 8bf0 e8???????? }
            // n = 6, score = 100
            //   52                   | push                edx
            //   53                   | push                ebx
            //   57                   | push                edi
            //   68????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     

        $sequence_1 = { 89442420 ff15???????? 837c243400 8bf0 0f86fd000000 }
            // n = 5, score = 100
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   ff15????????         |                     
            //   837c243400           | cmp                 dword ptr [esp + 0x34], 0
            //   8bf0                 | mov                 esi, eax
            //   0f86fd000000         | jbe                 0x103

        $sequence_2 = { 57 e9???????? e8???????? 85c0 7458 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   e9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7458                 | je                  0x5a

        $sequence_3 = { 8d442424 50 895c2424 895c2420 895c2428 }
            // n = 5, score = 100
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   895c2428             | mov                 dword ptr [esp + 0x28], ebx

        $sequence_4 = { 83c440 8d0c24 68???????? 51 }
            // n = 4, score = 100
            //   83c440               | add                 esp, 0x40
            //   8d0c24               | lea                 ecx, [esp]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_5 = { 52 8d442424 50 e8???????? 8d4c241c }
            // n = 5, score = 100
            //   52                   | push                edx
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]

        $sequence_6 = { 56 50 33db e8???????? 8d4c240c 68???????? }
            // n = 6, score = 100
            //   56                   | push                esi
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   e8????????           |                     
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   68????????           |                     

        $sequence_7 = { e8???????? 8b4c2478 8b542474 51 52 8d442424 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4c2478             | mov                 ecx, dword ptr [esp + 0x78]
            //   8b542474             | mov                 edx, dword ptr [esp + 0x74]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax

        $sequence_8 = { 0f94c1 8d0c8d01000000 51 52 }
            // n = 4, score = 100
            //   0f94c1               | sete                cl
            //   8d0c8d01000000       | lea                 ecx, [ecx*4 + 1]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_9 = { ffd5 66833c467c 0f8487000000 66833f21 752a 57 ffd5 }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   66833c467c           | cmp                 word ptr [esi + eax*2], 0x7c
            //   0f8487000000         | je                  0x8d
            //   66833f21             | cmp                 word ptr [edi], 0x21
            //   752a                 | jne                 0x2c
            //   57                   | push                edi
            //   ffd5                 | call                ebp

    condition:
        7 of them and filesize < 139264
}