rule win_cryptomix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cryptomix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptomix"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? ffd6 85c0 0f8503010000 837d0c01 }
            // n = 5, score = 200
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f8503010000         | jne                 0x109
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1

        $sequence_1 = { 85c0 0f85c1000000 8b35???????? 68007d0000 6a40 }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   0f85c1000000         | jne                 0xc7
            //   8b35????????         |                     
            //   68007d0000           | push                0x7d00
            //   6a40                 | push                0x40

        $sequence_2 = { 6801000080 ff15???????? 6a04 8d85e8fbffff 50 6a04 }
            // n = 6, score = 200
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   6a04                 | push                4
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   6a04                 | push                4

        $sequence_3 = { 59 59 8945f0 5e 837dfc00 740d ff75fc }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   5e                   | pop                 esi
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   740d                 | je                  0xf
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_4 = { 3db4263169 0f85a4000000 b801000000 8b4dfc 33cd e8???????? }
            // n = 6, score = 200
            //   3db4263169           | cmp                 eax, 0x693126b4
            //   0f85a4000000         | jne                 0xaa
            //   b801000000           | mov                 eax, 1
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     

        $sequence_5 = { 7504 6a07 eb3e 83f803 }
            // n = 4, score = 200
            //   7504                 | jne                 6
            //   6a07                 | push                7
            //   eb3e                 | jmp                 0x40
            //   83f803               | cmp                 eax, 3

        $sequence_6 = { c3 55 8bec 51 68ee7fd6aa 6a05 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   68ee7fd6aa           | push                0xaad67fee
            //   6a05                 | push                5

        $sequence_7 = { 668b01 83c102 6685c0 75f5 8b3d???????? 2bca }
            // n = 6, score = 200
            //   668b01               | mov                 ax, word ptr [ecx]
            //   83c102               | add                 ecx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   8b3d????????         |                     
            //   2bca                 | sub                 ecx, edx

        $sequence_8 = { e8???????? 83c420 ff75fc e8???????? ff75fc e8???????? 59 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_9 = { ff75f4 53 6a19 ff75fc e8???????? }
            // n = 5, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   53                   | push                ebx
            //   6a19                 | push                0x19
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_10 = { e8???????? 68f097a090 6a05 e8???????? 83c410 8d4df0 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   68f097a090           | push                0x90a097f0
            //   6a05                 | push                5
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d4df0               | lea                 ecx, [ebp - 0x10]

        $sequence_11 = { 8d85c4f9ffff 50 8d85e8fbffff 50 ffd3 ff750c }
            // n = 6, score = 200
            //   8d85c4f9ffff         | lea                 eax, [ebp - 0x63c]
            //   50                   | push                eax
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_12 = { 6808020000 8d8df8fdffff 51 6a00 ffd0 ff7508 8d85e8f9ffff }
            // n = 7, score = 200
            //   6808020000           | push                0x208
            //   8d8df8fdffff         | lea                 ecx, [ebp - 0x208]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ffd0                 | call                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d85e8f9ffff         | lea                 eax, [ebp - 0x618]

        $sequence_13 = { 8d5201 663bc6 72f5 8bf7 c7450800010000 8a16 }
            // n = 6, score = 200
            //   8d5201               | lea                 edx, [edx + 1]
            //   663bc6               | cmp                 ax, si
            //   72f5                 | jb                  0xfffffff7
            //   8bf7                 | mov                 esi, edi
            //   c7450800010000       | mov                 dword ptr [ebp + 8], 0x100
            //   8a16                 | mov                 dl, byte ptr [esi]

        $sequence_14 = { 668b8df4fdffff 33c0 8d95f4fdffff 6685c9 7418 }
            // n = 5, score = 200
            //   668b8df4fdffff       | mov                 cx, word ptr [ebp - 0x20c]
            //   33c0                 | xor                 eax, eax
            //   8d95f4fdffff         | lea                 edx, [ebp - 0x20c]
            //   6685c9               | test                cx, cx
            //   7418                 | je                  0x1a

        $sequence_15 = { e8???????? 59 59 ff742404 ffd0 c3 68c1ea9d27 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   ff742404             | push                dword ptr [esp + 4]
            //   ffd0                 | call                eax
            //   c3                   | ret                 
            //   68c1ea9d27           | push                0x279deac1

    condition:
        7 of them and filesize < 188416
}