rule win_cuba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cuba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cuba"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0019 43 41 00444341 }
            // n = 4, score = 100
            //   0019                 | add                 byte ptr [ecx], bl
            //   43                   | inc                 ebx
            //   41                   | inc                 ecx
            //   00444341             | add                 byte ptr [ebx + eax*2 + 0x41], al

        $sequence_1 = { 0026 43 41 00b043410062 }
            // n = 4, score = 100
            //   0026                 | add                 byte ptr [esi], ah
            //   43                   | inc                 ebx
            //   41                   | inc                 ecx
            //   00b043410062         | add                 byte ptr [eax + 0x62004143], dh

        $sequence_2 = { 3914c5e89b4100 7408 40 83f81d 7cf1 }
            // n = 5, score = 100
            //   3914c5e89b4100       | cmp                 dword ptr [eax*8 + 0x419be8], edx
            //   7408                 | je                  0xa
            //   40                   | inc                 eax
            //   83f81d               | cmp                 eax, 0x1d
            //   7cf1                 | jl                  0xfffffff3

        $sequence_3 = { a1???????? 33c5 8945fc e8???????? 84c0 0f854d010000 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f854d010000         | jne                 0x153

        $sequence_4 = { 000d???????? 384100 b538 41 }
            // n = 4, score = 100
            //   000d????????         |                     
            //   384100               | cmp                 byte ptr [ecx], al
            //   b538                 | mov                 ch, 0x38
            //   41                   | inc                 ecx

        $sequence_5 = { 8d85fcfeffff 898df8fdffff 50 6a01 53 ff15???????? ffb5fcfeffff }
            // n = 7, score = 100
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   898df8fdffff         | mov                 dword ptr [ebp - 0x208], ecx
            //   50                   | push                eax
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   ffb5fcfeffff         | push                dword ptr [ebp - 0x104]

        $sequence_6 = { 03b1e0b14100 8bc3 03b40dfcfeffff 03b5ecfeffff }
            // n = 4, score = 100
            //   03b1e0b14100         | add                 esi, dword ptr [ecx + 0x41b1e0]
            //   8bc3                 | mov                 eax, ebx
            //   03b40dfcfeffff       | add                 esi, dword ptr [ebp + ecx - 0x104]
            //   03b5ecfeffff         | add                 esi, dword ptr [ebp - 0x114]

        $sequence_7 = { 8985bcf9ffff 83cfff 33c0 c785c0f9ffff2c020000 668985ecfbffff 668985f4fdffff 8d85c0f9ffff }
            // n = 7, score = 100
            //   8985bcf9ffff         | mov                 dword ptr [ebp - 0x644], eax
            //   83cfff               | or                  edi, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   c785c0f9ffff2c020000     | mov    dword ptr [ebp - 0x640], 0x22c
            //   668985ecfbffff       | mov                 word ptr [ebp - 0x414], ax
            //   668985f4fdffff       | mov                 word ptr [ebp - 0x20c], ax
            //   8d85c0f9ffff         | lea                 eax, [ebp - 0x640]

        $sequence_8 = { 3385ecfeffff 0bcb 03f0 238df4feffff 8b85e0feffff 03b40508ffffff 03b0ecb14100 }
            // n = 7, score = 100
            //   3385ecfeffff         | xor                 eax, dword ptr [ebp - 0x114]
            //   0bcb                 | or                  ecx, ebx
            //   03f0                 | add                 esi, eax
            //   238df4feffff         | and                 ecx, dword ptr [ebp - 0x10c]
            //   8b85e0feffff         | mov                 eax, dword ptr [ebp - 0x120]
            //   03b40508ffffff       | add                 esi, dword ptr [ebp + eax - 0xf8]
            //   03b0ecb14100         | add                 esi, dword ptr [eax + 0x41b1ec]

        $sequence_9 = { c745e008934100 e9???????? c745e010934100 e9???????? c745e018934100 }
            // n = 5, score = 100
            //   c745e008934100       | mov                 dword ptr [ebp - 0x20], 0x419308
            //   e9????????           |                     
            //   c745e010934100       | mov                 dword ptr [ebp - 0x20], 0x419310
            //   e9????????           |                     
            //   c745e018934100       | mov                 dword ptr [ebp - 0x20], 0x419318

        $sequence_10 = { 0026 45 41 003a }
            // n = 4, score = 100
            //   0026                 | add                 byte ptr [esi], ah
            //   45                   | inc                 ebp
            //   41                   | inc                 ecx
            //   003a                 | add                 byte ptr [edx], bh

        $sequence_11 = { e8???????? 8bf8 b900010000 8d85f8fdffff 89bdbcfbffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   b900010000           | mov                 ecx, 0x100
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   89bdbcfbffff         | mov                 dword ptr [ebp - 0x444], edi

        $sequence_12 = { 000c43 41 0035???????? 43 }
            // n = 4, score = 100
            //   000c43               | add                 byte ptr [ebx + eax*2], cl
            //   41                   | inc                 ecx
            //   0035????????         |                     
            //   43                   | inc                 ebx

        $sequence_13 = { 003a 45 41 004245 }
            // n = 4, score = 100
            //   003a                 | add                 byte ptr [edx], bh
            //   45                   | inc                 ebp
            //   41                   | inc                 ecx
            //   004245               | add                 byte ptr [edx + 0x45], al

        $sequence_14 = { 0012 45 41 0026 }
            // n = 4, score = 100
            //   0012                 | add                 byte ptr [edx], dl
            //   45                   | inc                 ebp
            //   41                   | inc                 ecx
            //   0026                 | add                 byte ptr [esi], ah

        $sequence_15 = { 000446 41 00d1 45 }
            // n = 4, score = 100
            //   000446               | add                 byte ptr [esi + eax*2], al
            //   41                   | inc                 ecx
            //   00d1                 | add                 cl, dl
            //   45                   | inc                 ebp

    condition:
        7 of them and filesize < 1094656
}