rule win_cuegoe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cuegoe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cuegoe"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895dfc e8???????? 59 8d4dd0 8bf0 e8???????? }
            // n = 6, score = 200
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     

        $sequence_1 = { 83781808 7205 8b4004 eb03 83c004 8d4de4 51 }
            // n = 7, score = 200
            //   83781808             | cmp                 dword ptr [eax + 0x18], 8
            //   7205                 | jb                  7
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   eb03                 | jmp                 5
            //   83c004               | add                 eax, 4
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   51                   | push                ecx

        $sequence_2 = { 324dfe 80e17f 3008 8b06 8bc8 c1f905 8b0c8d80cf0310 }
            // n = 7, score = 200
            //   324dfe               | xor                 cl, byte ptr [ebp - 2]
            //   80e17f               | and                 cl, 0x7f
            //   3008                 | xor                 byte ptr [eax], cl
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d80cf0310       | mov                 ecx, dword ptr [ecx*4 + 0x1003cf80]

        $sequence_3 = { 8b4534 c645fc06 e8???????? 33f6 397548 7409 }
            // n = 6, score = 200
            //   8b4534               | mov                 eax, dword ptr [ebp + 0x34]
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi
            //   397548               | cmp                 dword ptr [ebp + 0x48], esi
            //   7409                 | je                  0xb

        $sequence_4 = { 8b7da8 3bfb 7636 803e7f 7431 4f }
            // n = 6, score = 200
            //   8b7da8               | mov                 edi, dword ptr [ebp - 0x58]
            //   3bfb                 | cmp                 edi, ebx
            //   7636                 | jbe                 0x38
            //   803e7f               | cmp                 byte ptr [esi], 0x7f
            //   7431                 | je                  0x33
            //   4f                   | dec                 edi

        $sequence_5 = { c1e108 330c9d68a10310 bb01000000 898860020000 885c0658 8b7044 8b4824 }
            // n = 7, score = 200
            //   c1e108               | shl                 ecx, 8
            //   330c9d68a10310       | xor                 ecx, dword ptr [ebx*4 + 0x1003a168]
            //   bb01000000           | mov                 ebx, 1
            //   898860020000         | mov                 dword ptr [eax + 0x260], ecx
            //   885c0658             | mov                 byte ptr [esi + eax + 0x58], bl
            //   8b7044               | mov                 esi, dword ptr [eax + 0x44]
            //   8b4824               | mov                 ecx, dword ptr [eax + 0x24]

        $sequence_6 = { a1???????? 33c5 894558 6a38 b8???????? e8???????? }
            // n = 6, score = 200
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   894558               | mov                 dword ptr [ebp + 0x58], eax
            //   6a38                 | push                0x38
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_7 = { 894d14 8b4804 83c40c 03f7 297d0c 894d18 742c }
            // n = 7, score = 200
            //   894d14               | mov                 dword ptr [ebp + 0x14], ecx
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   83c40c               | add                 esp, 0xc
            //   03f7                 | add                 esi, edi
            //   297d0c               | sub                 dword ptr [ebp + 0xc], edi
            //   894d18               | mov                 dword ptr [ebp + 0x18], ecx
            //   742c                 | je                  0x2e

        $sequence_8 = { eb02 33c0 8903 8365fc00 8d45f3 50 8b450c }
            // n = 7, score = 200
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8d45f3               | lea                 eax, [ebp - 0xd]
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_9 = { ff7004 ff30 8d45d4 50 8bc6 e8???????? 8bc6 }
            // n = 7, score = 200
            //   ff7004               | push                dword ptr [eax + 4]
            //   ff30                 | push                dword ptr [eax]
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi

    condition:
        7 of them and filesize < 540672
}