rule win_cybergate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cybergate"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8de8feffff b8???????? ba???????? e8???????? c645ff00 e9???????? 837f0800 }
            // n = 7, score = 700
            //   8b8de8feffff         | mov                 ecx, dword ptr [ebp - 0x118]
            //   b8????????           |                     
            //   ba????????           |                     
            //   e8????????           |                     
            //   c645ff00             | mov                 byte ptr [ebp - 1], 0
            //   e9????????           |                     
            //   837f0800             | cmp                 dword ptr [edi + 8], 0

        $sequence_1 = { 3c2e 7516 57 8bc6 e8???????? }
            // n = 5, score = 700
            //   3c2e                 | cmp                 al, 0x2e
            //   7516                 | jne                 0x18
            //   57                   | push                edi
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     

        $sequence_2 = { 741a 8b55f8 b8???????? e8???????? 48 7d83 }
            // n = 6, score = 700
            //   741a                 | je                  0x1c
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   b8????????           |                     
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   7d83                 | jge                 0xffffff85

        $sequence_3 = { 8b55f8 807c02ff5c 747c 8d45f8 }
            // n = 4, score = 700
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   807c02ff5c           | cmp                 byte ptr [edx + eax - 1], 0x5c
            //   747c                 | je                  0x7e
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_4 = { 8b5708 8b4df0 890a 294708 ff470c 8b45f4 8b00 }
            // n = 7, score = 700
            //   8b5708               | mov                 edx, dword ptr [edi + 8]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   890a                 | mov                 dword ptr [edx], ecx
            //   294708               | sub                 dword ptr [edi + 8], eax
            //   ff470c               | inc                 dword ptr [edi + 0xc]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_5 = { 83c103 8b03 ba01000000 e8???????? 8d55f0 }
            // n = 5, score = 700
            //   83c103               | add                 ecx, 3
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   ba01000000           | mov                 edx, 1
            //   e8????????           |                     
            //   8d55f0               | lea                 edx, [ebp - 0x10]

        $sequence_6 = { 8b520c 03d6 e8???????? 8b8de8feffff b8???????? ba???????? }
            // n = 6, score = 700
            //   8b520c               | mov                 edx, dword ptr [edx + 0xc]
            //   03d6                 | add                 edx, esi
            //   e8????????           |                     
            //   8b8de8feffff         | mov                 ecx, dword ptr [ebp - 0x118]
            //   b8????????           |                     
            //   ba????????           |                     

        $sequence_7 = { 4b 85db 75db 5a 5f }
            // n = 5, score = 700
            //   4b                   | dec                 ebx
            //   85db                 | test                ebx, ebx
            //   75db                 | jne                 0xffffffdd
            //   5a                   | pop                 edx
            //   5f                   | pop                 edi

        $sequence_8 = { 8b03 ba01000000 e8???????? 8d55f0 }
            // n = 4, score = 700
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   ba01000000           | mov                 edx, 1
            //   e8????????           |                     
            //   8d55f0               | lea                 edx, [ebp - 0x10]

        $sequence_9 = { 40 84c0 741a 8b55f8 b8???????? e8???????? 48 }
            // n = 7, score = 700
            //   40                   | inc                 eax
            //   84c0                 | test                al, al
            //   741a                 | je                  0x1c
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   b8????????           |                     
            //   e8????????           |                     
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 9191424
}