rule win_darkbit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.darkbit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkbit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 488d0d93861800 48898c2488010000 4889842490010000 488b8424f8010000 488b9c2478010000 488b8c2490000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d0d93861800       | jmp                 0x1bdb
            //   48898c2488010000     | inc                 esp
            //   4889842490010000     | movzx               ecx, byte ptr [esp + edi + 0x1f]
            //   488b8424f8010000     | inc                 ecx
            //   488b9c2478010000     | xor                 ecx, esi
            //   488b8c2490000000     | inc                 esp

        $sequence_1 = { e8???????? 488d3d5b7d2200 e8???????? e8???????? 48898424e0240000 48899c24b0080000 488b0d???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d3d5b7d2200       | movzx               edx, byte ptr [esp + 0x8b]
            //   e8????????           |                     
            //   e8????????           |                     
            //   48898424e0240000     | mov                 byte ptr [esp + 0x4f], dl
            //   48899c24b0080000     | inc                 esp
            //   488b0d????????       |                     

        $sequence_2 = { eb42 48898424d0020000 48899c24f0000000 488d0504370300 488b9c24d8020000 e8???????? 488b9c24f0000000 }
            // n = 7, score = 100
            //   eb42                 | lea                 eax, [esp + 0xd8]
            //   48898424d0020000     | dec                 eax
            //   48899c24f0000000     | lea                 ebx, [esp + 0x44]
            //   488d0504370300       | mov                 ecx, 2
            //   488b9c24d8020000     | nop                 
            //   e8????????           |                     
            //   488b9c24f0000000     | dec                 eax

        $sequence_3 = { b91b000000 e8???????? 90 488b15???????? 488b8c2498000000 31ff 4889c6 }
            // n = 7, score = 100
            //   b91b000000           | mov                 eax, dword ptr [esp + 0xc8]
            //   e8????????           |                     
            //   90                   | inc                 dx
            //   488b15????????       |                     
            //   488b8c2498000000     | mov                 dword ptr [ebx + ebx], 0x8b4c6d70
            //   31ff                 | pushfd              
            //   4889c6               | and                 al, 0x18

        $sequence_4 = { e8???????? 488d05533f3800 bb1e000000 e8???????? 488d05a0293800 bb11000000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d05533f3800       | mov                 edx, dword ptr [esp + 0x28]
            //   bb1e000000           | dec                 eax
            //   e8????????           |                     
            //   488d05a0293800       | lea                 ecx, [edx + edx*2]
            //   bb11000000           | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { ebd7 4885db 742e 4889b110010000 48899118010000 488d05cc9b3700 e8???????? }
            // n = 7, score = 100
            //   ebd7                 | dec                 esp
            //   4885db               | lea                 eax, [ebx + 1]
            //   742e                 | dec                 esp
            //   4889b110010000       | cmp                 esi, eax
            //   48899118010000       | jae                 0x35c
            //   488d05cc9b3700       | dec                 eax
            //   e8????????           |                     

        $sequence_6 = { 90 90 488d0511971600 bb01000000 4889d9 e8???????? 4889842438010000 }
            // n = 7, score = 100
            //   90                   | dec                 eax
            //   90                   | mov                 esi, edx
            //   488d0511971600       | dec                 eax
            //   bb01000000           | mov                 edx, dword ptr [esp + 0xe8]
            //   4889d9               | dec                 eax
            //   e8????????           |                     
            //   4889842438010000     | mov                 esi, dword ptr [esp + 0x98]

        $sequence_7 = { e8???????? 488d3d8fdd2100 e8???????? 6690 e8???????? 48898424681d0000 48899c2438010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d3d8fdd2100       | mov                 byte ptr [esp + 0xa6], 0x21
            //   e8????????           |                     
            //   6690                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   48898424681d0000     | jmp                 0xf1f
            //   48899c2438010000     | movzx               edx, byte ptr [esp + ecx + 0xa7]

        $sequence_8 = { 90 4c8ba424e0030000 4d21d4 4d21e9 4d09cc 4c89a42410070000 48c784244006000000000000 }
            // n = 7, score = 100
            //   90                   | dec                 esp
            //   4c8ba424e0030000     | mov                 ebx, dword ptr [esp + 0x3e0]
            //   4d21d4               | dec                 ebp
            //   4d21e9               | and                 ebx, ecx
            //   4d09cc               | dec                 ecx
            //   4c89a42410070000     | or                  ebx, edx
            //   48c784244006000000000000     | dec    ecx

        $sequence_9 = { 90 c744245b44588096 c644245fcd c74424562c14e1d8 c644245a6c 31c0 e9???????? }
            // n = 7, score = 100
            //   90                   | dec                 esp
            //   c744245b44588096     | mov                 ecx, dword ptr [esp + 0x4a0]
            //   c644245fcd           | jmp                 0x1b1
            //   c74424562c14e1d8     | dec                 eax
            //   c644245a6c           | mov                 eax, dword ptr [esp + 0x4d0]
            //   31c0                 | dec                 eax
            //   e9????????           |                     

    condition:
        7 of them and filesize < 11612160
}