rule win_datper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.datper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.datper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45a0 50 8b45a8 50 e8???????? }
            // n = 5, score = 200
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]
            //   50                   | push                eax
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 56 53 e8???????? a3???????? 8d95d8fbffff b8???????? e8???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   a3????????           |                     
            //   8d95d8fbffff         | lea                 edx, [ebp - 0x428]
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 8b4514 50 68???????? 53 }
            // n = 4, score = 200
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   50                   | push                eax
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_3 = { e8???????? 8bf8 8b8574d7ffff a3???????? 68e8030000 e8???????? 8d45e4 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8b8574d7ffff         | mov                 eax, dword ptr [ebp - 0x288c]
            //   a3????????           |                     
            //   68e8030000           | push                0x3e8
            //   e8????????           |                     
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_4 = { d1e8 8bf0 8d45e8 50 8bce 8bd3 }
            // n = 6, score = 200
            //   d1e8                 | shr                 eax, 1
            //   8bf0                 | mov                 esi, eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   8bd3                 | mov                 edx, ebx

        $sequence_5 = { ba???????? 8b45fc e8???????? 8b95ecf9ffff b8???????? e8???????? 8d85e8f9ffff }
            // n = 7, score = 200
            //   ba????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b95ecf9ffff         | mov                 edx, dword ptr [ebp - 0x614]
            //   b8????????           |                     
            //   e8????????           |                     
            //   8d85e8f9ffff         | lea                 eax, [ebp - 0x618]

        $sequence_6 = { 55 68???????? 64ff30 648920 8d8578ffffff 50 e8???????? }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   68????????           |                     
            //   64ff30               | push                dword ptr fs:[eax]
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 75cd 8b45f8 5f 5e 5b }
            // n = 5, score = 200
            //   75cd                 | jne                 0xffffffcf
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_8 = { 83c604 4b 75ed bb02000000 8bf7 83c8ff e8???????? }
            // n = 7, score = 200
            //   83c604               | add                 esi, 4
            //   4b                   | dec                 ebx
            //   75ed                 | jne                 0xffffffef
            //   bb02000000           | mov                 ebx, 2
            //   8bf7                 | mov                 esi, edi
            //   83c8ff               | or                  eax, 0xffffffff
            //   e8????????           |                     

        $sequence_9 = { 8bd6 8bc6 e8???????? 33ff c745f400004000 }
            // n = 5, score = 200
            //   8bd6                 | mov                 edx, esi
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   c745f400004000       | mov                 dword ptr [ebp - 0xc], 0x400000

    condition:
        7 of them and filesize < 253952
}