rule win_dented_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dented."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dented"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? bf08020000 8d85ecfbffff 57 }
            // n = 4, score = 400
            //   68????????           |                     
            //   bf08020000           | mov                 edi, 0x208
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   57                   | push                edi

        $sequence_1 = { 8b16 50 8b442410 03c1 50 51 8bce }
            // n = 7, score = 400
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   50                   | push                eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi

        $sequence_2 = { 8b08 8b422c 8b00 2bc1 03c7 33db }
            // n = 6, score = 400
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b422c               | mov                 eax, dword ptr [edx + 0x2c]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   2bc1                 | sub                 eax, ecx
            //   03c7                 | add                 eax, edi
            //   33db                 | xor                 ebx, ebx

        $sequence_3 = { ffd6 ff75fc ffd6 6a00 6a01 8d4d08 e8???????? }
            // n = 7, score = 400
            //   ffd6                 | call                esi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd6                 | call                esi
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     

        $sequence_4 = { 8b45e0 c1e814 8b4dfc 5f 33cd 5e e8???????? }
            // n = 7, score = 400
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   c1e814               | shr                 eax, 0x14
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   33cd                 | xor                 ecx, ebp
            //   5e                   | pop                 esi
            //   e8????????           |                     

        $sequence_5 = { e8???????? 68???????? 8d85ecfbffff 57 50 e8???????? }
            // n = 6, score = 400
            //   e8????????           |                     
            //   68????????           |                     
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 51 ffb564ffffff 8d8dc0feffff e8???????? ba???????? }
            // n = 5, score = 400
            //   51                   | push                ecx
            //   ffb564ffffff         | push                dword ptr [ebp - 0x9c]
            //   8d8dc0feffff         | lea                 ecx, [ebp - 0x140]
            //   e8????????           |                     
            //   ba????????           |                     

        $sequence_7 = { 48 0d00ffffff 40 8a0a 8985f8f7ffff 8bbdf8f7ffff 0fb6c1 }
            // n = 7, score = 400
            //   48                   | dec                 eax
            //   0d00ffffff           | or                  eax, 0xffffff00
            //   40                   | inc                 eax
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   8985f8f7ffff         | mov                 dword ptr [ebp - 0x808], eax
            //   8bbdf8f7ffff         | mov                 edi, dword ptr [ebp - 0x808]
            //   0fb6c1               | movzx               eax, cl

        $sequence_8 = { 895df8 3b5df4 0f8270ffffff 5f }
            // n = 4, score = 400
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   3b5df4               | cmp                 ebx, dword ptr [ebp - 0xc]
            //   0f8270ffffff         | jb                  0xffffff76
            //   5f                   | pop                 edi

        $sequence_9 = { 59 8bf0 8bcf 33c0 89b5e8f7ffff 2185f0f7ffff }
            // n = 6, score = 400
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax
            //   8bcf                 | mov                 ecx, edi
            //   33c0                 | xor                 eax, eax
            //   89b5e8f7ffff         | mov                 dword ptr [ebp - 0x818], esi
            //   2185f0f7ffff         | and                 dword ptr [ebp - 0x810], eax

    condition:
        7 of them and filesize < 450560
}