rule win_derohe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.derohe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.derohe"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 8b542404 c60424fd 8b02 ffd0 8b542404 c6042412 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424fd             | mov                 byte ptr [esp], 0xfd
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042412             | mov                 byte ptr [esp], 0x12

        $sequence_1 = { ffd0 8b542404 c604249d 8b02 ffd0 8b542404 c6042481 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c604249d             | mov                 byte ptr [esp], 0x9d
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042481             | mov                 byte ptr [esp], 0x81

        $sequence_2 = { ffd0 8b542404 c6042496 8b02 ffd0 8b542404 c60424f6 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042496             | mov                 byte ptr [esp], 0x96
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424f6             | mov                 byte ptr [esp], 0xf6

        $sequence_3 = { ffd0 8b542404 c60424c0 8b02 ffd0 8b542404 c6042415 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424c0             | mov                 byte ptr [esp], 0xc0
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042415             | mov                 byte ptr [esp], 0x15

        $sequence_4 = { e8???????? ebec 8b44242c 8984248c000000 8b442424 89842490000000 8b442428 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ebec                 | jmp                 0xffffffee
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   8984248c000000       | mov                 dword ptr [esp + 0x8c], eax
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   89842490000000       | mov                 dword ptr [esp + 0x90], eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]

        $sequence_5 = { ffd0 8b542404 c60424e4 8b02 ffd0 8b542404 c6042467 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424e4             | mov                 byte ptr [esp], 0xe4
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042467             | mov                 byte ptr [esp], 0x67

        $sequence_6 = { f7e2 899424dc040000 89842478010000 8b442454 8b94248c010000 f7e2 899424d8040000 }
            // n = 7, score = 100
            //   f7e2                 | mul                 edx
            //   899424dc040000       | mov                 dword ptr [esp + 0x4dc], edx
            //   89842478010000       | mov                 dword ptr [esp + 0x178], eax
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]
            //   8b94248c010000       | mov                 edx, dword ptr [esp + 0x18c]
            //   f7e2                 | mul                 edx
            //   899424d8040000       | mov                 dword ptr [esp + 0x4d8], edx

        $sequence_7 = { ffd0 8b542404 c6042494 8b02 ffd0 8b542404 c60424de }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042494             | mov                 byte ptr [esp], 0x94
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424de             | mov                 byte ptr [esp], 0xde

        $sequence_8 = { ffd0 8b542404 c60424f4 8b02 ffd0 8b542404 c6042487 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424f4             | mov                 byte ptr [esp], 0xf4
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042487             | mov                 byte ptr [esp], 0x87

        $sequence_9 = { ffd0 8b542404 c60424ae 8b02 ffd0 8b542404 c6042416 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424ae             | mov                 byte ptr [esp], 0xae
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042416             | mov                 byte ptr [esp], 0x16

    condition:
        7 of them and filesize < 35788800
}