rule win_diavol_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.diavol."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.diavol"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7532 8b85d0fbffff 50 6a00 6a01 ff15???????? 8bf0 }
            // n = 7, score = 100
            //   7532                 | jne                 0x34
            //   8b85d0fbffff         | mov                 eax, dword ptr [ebp - 0x430]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_1 = { 32d2 eb16 83f975 7207 8945fc 8bd8 eb0a }
            // n = 7, score = 100
            //   32d2                 | xor                 dl, dl
            //   eb16                 | jmp                 0x18
            //   83f975               | cmp                 ecx, 0x75
            //   7207                 | jb                  9
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8bd8                 | mov                 ebx, eax
            //   eb0a                 | jmp                 0xc

        $sequence_2 = { 0fb7045e 83c40c 83f825 7416 8d8dfcfeffff }
            // n = 5, score = 100
            //   0fb7045e             | movzx               eax, word ptr [esi + ebx*2]
            //   83c40c               | add                 esp, 0xc
            //   83f825               | cmp                 eax, 0x25
            //   7416                 | je                  0x18
            //   8d8dfcfeffff         | lea                 ecx, [ebp - 0x104]

        $sequence_3 = { 741d 83f93f 7412 66837dfc2a }
            // n = 4, score = 100
            //   741d                 | je                  0x1f
            //   83f93f               | cmp                 ecx, 0x3f
            //   7412                 | je                  0x14
            //   66837dfc2a           | cmp                 word ptr [ebp - 4], 0x2a

        $sequence_4 = { 57 e8???????? 8b4dfc 83c410 8bc7 5f 5e }
            // n = 7, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c410               | add                 esp, 0x10
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_5 = { ff15???????? 8bf0 89b5c0fbffff 83feff }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   89b5c0fbffff         | mov                 dword ptr [ebp - 0x440], esi
            //   83feff               | cmp                 esi, -1

        $sequence_6 = { e8???????? 83c40c 8b4dfc 5f 5e 33cd b001 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33cd                 | xor                 ecx, ebp
            //   b001                 | mov                 al, 1

        $sequence_7 = { 33c0 85ff 7420 8b0d???????? 8bff 66833c413b }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   85ff                 | test                edi, edi
            //   7420                 | je                  0x22
            //   8b0d????????         |                     
            //   8bff                 | mov                 edi, edi
            //   66833c413b           | cmp                 word ptr [ecx + eax*2], 0x3b

        $sequence_8 = { 85c0 0f8465ffffff 8d95f4efffff 2bd6 f685a4edffff10 8bc6 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f8465ffffff         | je                  0xffffff6b
            //   8d95f4efffff         | lea                 edx, [ebp - 0x100c]
            //   2bd6                 | sub                 edx, esi
            //   f685a4edffff10       | test                byte ptr [ebp - 0x125c], 0x10
            //   8bc6                 | mov                 eax, esi

        $sequence_9 = { 8945fc 6880000000 8d8578ffffff 6a00 50 }
            // n = 5, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   6880000000           | push                0x80
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   6a00                 | push                0
            //   50                   | push                eax

    condition:
        7 of them and filesize < 191488
}