rule win_diceloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.diceloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.diceloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bf8 895808 89680c e8???????? }
            // n = 4, score = 100
            //   488bf8               | jne                 0x5f9
            //   895808               | dec                 eax
            //   89680c               | and                 ecx, ebx
            //   e8????????           |                     

        $sequence_1 = { 4885c0 745a b924000000 e8???????? 0fb6c8 ba01000000 6bc107 }
            // n = 7, score = 100
            //   4885c0               | mov                 eax, dword ptr [ecx]
            //   745a                 | dec                 eax
            //   b924000000           | mov                 edi, ecx
            //   e8????????           |                     
            //   0fb6c8               | dec                 eax
            //   ba01000000           | test                eax, eax
            //   6bc107               | je                  0x5ae

        $sequence_2 = { 895808 89680c e8???????? 48894710 488d4f1c }
            // n = 5, score = 100
            //   895808               | mov                 dword ptr [esp + 0x20], esi
            //   89680c               | dec                 esp
            //   e8????????           |                     
            //   48894710             | mov                 dword ptr [esp + 0x3c], edi
            //   488d4f1c             | inc                 esp

        $sequence_3 = { 4889742410 48897c2418 4156 4883ec30 8bf2 ff15???????? }
            // n = 6, score = 100
            //   4889742410           | sub                 ecx, eax
            //   48897c2418           | inc                 esp
            //   4156                 | sub                 ecx, edi
            //   4883ec30             | jne                 0x1744
            //   8bf2                 | mov                 ecx, 0x400
            //   ff15????????         |                     

        $sequence_4 = { 0f8483000000 8b5de8 3bf3 7c81 448b6dd8 41b81e000000 488d4d58 }
            // n = 7, score = 100
            //   0f8483000000         | add                 ecx, edi
            //   8b5de8               | inc                 ecx
            //   3bf3                 | lea                 edi, [esi + 2]
            //   7c81                 | inc                 ebp
            //   448b6dd8             | lea                 ebp, [esi + 4]
            //   41b81e000000         | add                 al, bl
            //   488d4d58             | mov                 byte ptr [ebp + 0x61], al

        $sequence_5 = { 41b9983a0000 488d1daa2a0000 8bcf 488bd3 ff15???????? 488b0b ff15???????? }
            // n = 7, score = 100
            //   41b9983a0000         | inc                 esp
            //   488d1daa2a0000       | mov                 ebp, ebx
            //   8bcf                 | mov                 eax, 0x1000
            //   488bd3               | inc                 esp
            //   ff15????????         |                     
            //   488b0b               | sub                 ebp, esi
            //   ff15????????         |                     

        $sequence_6 = { 468b540324 4d03c8 4d03d0 418b11 }
            // n = 4, score = 100
            //   468b540324           | mov                 byte ptr [ebp + eax - 0x50], al
            //   4d03c8               | dec                 esp
            //   4d03d0               | add                 eax, edi
            //   418b11               | inc                 edx

        $sequence_7 = { b001 eb45 8b410c 99 2bc2 }
            // n = 5, score = 100
            //   b001                 | shr                 eax, 0x10
            //   eb45                 | inc                 dx
            //   8b410c               | add                 dword ptr [ecx + eax], eax
            //   99                   | jmp                 0xa1e
            //   2bc2                 | dec                 eax

        $sequence_8 = { 448b541620 8b5c1624 4c03d2 4803da 4533c9 458d7901 458b02 }
            // n = 7, score = 100
            //   448b541620           | dec                 ecx
            //   8b5c1624             | add                 eax, ebp
            //   4c03d2               | dec                 ecx
            //   4803da               | mov                 dword ptr [edi], eax
            //   4533c9               | xor                 ecx, ecx
            //   458d7901             | dec                 eax
            //   458b02               | sub                 edx, ecx

        $sequence_9 = { 4983c602 4c03f7 498bd6 ffd5 }
            // n = 4, score = 100
            //   4983c602             | lea                 edx, [0x876]
            //   4c03f7               | dec                 eax
            //   498bd6               | lea                 ecx, [0x2683]
            //   ffd5                 | dec                 eax

    condition:
        7 of them and filesize < 41984
}