rule win_dispcashbr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dispcashbr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dispcashbr"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83ec08 c7442408ceffffff c7442404???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408ceffffff     | mov                 dword ptr [esp + 8], 0xffffffce
            //   c7442404????????     |                     

        $sequence_1 = { e8???????? 83ec08 c7442408eaffffff c7442404???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408eaffffff     | mov                 dword ptr [esp + 8], 0xffffffea
            //   c7442404????????     |                     

        $sequence_2 = { 83ec04 c744240404000000 890424 e8???????? 83ec08 c7442408d9ffffff c7442404???????? }
            // n = 7, score = 200
            //   83ec04               | sub                 esp, 4
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408d9ffffff     | mov                 dword ptr [esp + 8], 0xffffffd9
            //   c7442404????????     |                     

        $sequence_3 = { c744240404000000 890424 e8???????? 83ec08 c7442408f3ffffff c7442404???????? }
            // n = 6, score = 200
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408f3ffffff     | mov                 dword ptr [esp + 8], 0xfffffff3
            //   c7442404????????     |                     

        $sequence_4 = { e8???????? 83ec04 c744240404000000 890424 e8???????? 83ec08 c7442408ceffffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408ceffffff     | mov                 dword ptr [esp + 8], 0xffffffce

        $sequence_5 = { 83ec08 c7442408caffffff c7442404???????? a1???????? 83c020 890424 e8???????? }
            // n = 7, score = 200
            //   83ec08               | sub                 esp, 8
            //   c7442408caffffff     | mov                 dword ptr [esp + 8], 0xffffffca
            //   c7442404????????     |                     
            //   a1????????           |                     
            //   83c020               | add                 eax, 0x20
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_6 = { c7442408c8ffffff c7442404???????? a1???????? 83c020 890424 e8???????? }
            // n = 6, score = 200
            //   c7442408c8ffffff     | mov                 dword ptr [esp + 8], 0xffffffc8
            //   c7442404????????     |                     
            //   a1????????           |                     
            //   83c020               | add                 eax, 0x20
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_7 = { 890424 e8???????? eb45 c70424f5ffffff }
            // n = 4, score = 200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   eb45                 | jmp                 0x47
            //   c70424f5ffffff       | mov                 dword ptr [esp], 0xfffffff5

        $sequence_8 = { 83ec08 c7442408ccffffff c7442404???????? a1???????? }
            // n = 4, score = 200
            //   83ec08               | sub                 esp, 8
            //   c7442408ccffffff     | mov                 dword ptr [esp + 8], 0xffffffcc
            //   c7442404????????     |                     
            //   a1????????           |                     

        $sequence_9 = { e8???????? 83ec08 c7442408ccffffff c7442404???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408ccffffff     | mov                 dword ptr [esp + 8], 0xffffffcc
            //   c7442404????????     |                     

    condition:
        7 of them and filesize < 123904
}