rule win_doorme_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.doorme."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doorme"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4180f04b 4488442434 4180f14b 44884c2435 4180f24b 4488542436 44885c2437 }
            // n = 7, score = 100
            //   4180f04b             | lea                 eax, [ebp + 0x2e0]
            //   4488442434           | dec                 eax
            //   4180f14b             | cmp                 dword ptr [ebp + 0x2f8], 0x10
            //   44884c2435           | dec                 eax
            //   4180f24b             | cmovae              eax, dword ptr [ebp + 0x2e0]
            //   4488542436           | dec                 eax
            //   44885c2437           | lea                 ecx, [ebp + 0x2e0]

        $sequence_1 = { 0f87c8010000 e8???????? 660f6f05???????? f30f7f442450 c644244000 488b542438 4883fa10 }
            // n = 7, score = 100
            //   0f87c8010000         | lea                 edx, [0x1befc]
            //   e8????????           |                     
            //   660f6f05????????     |                     
            //   f30f7f442450         | dec                 eax
            //   c644244000           | lea                 edx, [0x19b06]
            //   488b542438           | jb                  0x1eb4
            //   4883fa10             | subsd               xmm1, xmm2

        $sequence_2 = { 4a8d0432 488bd9 483bc8 480f42d8 488bc3 48897c2458 4883c001 }
            // n = 7, score = 100
            //   4a8d0432             | jne                 0xa16
            //   488bd9               | inc                 ecx
            //   483bc8               | movzx               eax, cl
            //   480f42d8             | inc                 esi
            //   488bc3               | movzx               ecx, byte ptr [eax + 0x38620]
            //   48897c2458           | inc                 esi
            //   4883c001             | xor                 dl, byte ptr [eax + 0x38620]

        $sequence_3 = { 4883c428 e9???????? 83f808 7d14 488d0c80 488d05f03d0300 488d0cc8 }
            // n = 7, score = 100
            //   4883c428             | mov                 ecx, dword ptr [ebx]
            //   e9????????           |                     
            //   83f808               | dec                 eax
            //   7d14                 | test                ecx, ecx
            //   488d0c80             | je                  0x1b19
            //   488d05f03d0300       | test                cl, cl
            //   488d0cc8             | jne                 0x1b46

        $sequence_4 = { 0f87e4010000 498bc8 e8???????? 49897f10 49c747180f000000 41c60700 }
            // n = 6, score = 100
            //   0f87e4010000         | dec                 eax
            //   498bc8               | sub                 esp, 0xf0
            //   e8????????           |                     
            //   49897f10             | dec                 eax
            //   49c747180f000000     | mov                 dword ptr [ebp + 7], 0xfffffffe
            //   41c60700             | dec                 eax

        $sequence_5 = { e8???????? 660f6f05???????? f30f7f4588 c644247800 498b5618 4883fa10 0f82e2010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   660f6f05????????     |                     
            //   f30f7f4588           | dec                 eax
            //   c644247800           | mov                 dword ptr [esp + 0x2430], esi
            //   498b5618             | dec                 eax
            //   4883fa10             | lea                 ebp, [esp - 0xc0]
            //   0f82e2010000         | dec                 eax

        $sequence_6 = { 488d1560b90100 c4e2c9abe9 c4817b1004c1 c4a153581cc2 c5f928cb c5e35cda c4e2c9b905???????? }
            // n = 7, score = 100
            //   488d1560b90100       | lea                 eax, [0x1b66d]
            //   c4e2c9abe9           | dec                 eax
            //   c4817b1004c1         | mov                 dword ptr [ebx], eax
            //   c4a153581cc2         | xor                 ecx, ecx
            //   c5f928cb             | dec                 eax
            //   c5e35cda             | mov                 dword ptr [edx], ecx
            //   c4e2c9b905????????     |     

        $sequence_7 = { 4c8d0dc8ca0100 8bf9 488d158f860100 b903000000 4c8d05abca0100 e8???????? 488bd3 }
            // n = 7, score = 100
            //   4c8d0dc8ca0100       | dec                 eax
            //   8bf9                 | mov                 dword ptr [esp + 0xa0], eax
            //   488d158f860100       | dec                 eax
            //   b903000000           | mov                 ebp, ecx
            //   4c8d05abca0100       | xor                 edx, edx
            //   e8????????           |                     
            //   488bd3               | dec                 ecx

        $sequence_8 = { 4053 4883ec20 84c9 752f 488d1d2b730200 488b0b 4885c9 }
            // n = 7, score = 100
            //   4053                 | dec                 eax
            //   4883ec20             | lea                 ecx, [edi + 0x20]
            //   84c9                 | dec                 eax
            //   752f                 | lea                 edx, [esp + 0x20]
            //   488d1d2b730200       | dec                 eax
            //   488b0b               | mov                 edx, dword ptr [ebp - 0x71]
            //   4885c9               | dec                 eax

        $sequence_9 = { 4883c510 4c8d15f06b0300 48836c243001 0f8564feffff 4c8bc6 448d4a04 4c8d15d66b0300 }
            // n = 7, score = 100
            //   4883c510             | lea                 edx, [0x155f9]
            //   4c8d15f06b0300       | dec                 eax
            //   48836c243001         | lea                 ecx, [ebp + 0x60]
            //   0f8564feffff         | test                eax, eax
            //   4c8bc6               | je                  0x1c3b
            //   448d4a04             | dec                 eax
            //   4c8d15d66b0300       | lea                 edx, [0xe290]

    condition:
        7 of them and filesize < 580608
}