rule win_dtrack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dtrack."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dtrack"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 8b4508 50 e8???????? 83c414 8b4d10 51 }
            // n = 7, score = 400
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx

        $sequence_1 = { 8d85e8fbffff 50 e8???????? 83c40c 8d8da8faffff 51 }
            // n = 6, score = 300
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8da8faffff         | lea                 ecx, [ebp - 0x558]
            //   51                   | push                ecx

        $sequence_2 = { 8945fc 68???????? e8???????? 83c404 50 8b55fc }
            // n = 6, score = 300
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_3 = { 51 e8???????? 83c410 8b558c }
            // n = 4, score = 300
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b558c               | mov                 edx, dword ptr [ebp - 0x74]

        $sequence_4 = { 8d95b1faffff 52 e8???????? 83c40c }
            // n = 4, score = 300
            //   8d95b1faffff         | lea                 edx, [ebp - 0x54f]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 8995e8f5ffff 8a85e8f5ffff 888587f6ffff 8b0d???????? 51 }
            // n = 5, score = 300
            //   8995e8f5ffff         | mov                 dword ptr [ebp - 0xa18], edx
            //   8a85e8f5ffff         | mov                 al, byte ptr [ebp - 0xa18]
            //   888587f6ffff         | mov                 byte ptr [ebp - 0x979], al
            //   8b0d????????         |                     
            //   51                   | push                ecx

        $sequence_6 = { 80bd4af6ffff00 75ae c78544f6ffff00000000 eb0b }
            // n = 4, score = 300
            //   80bd4af6ffff00       | cmp                 byte ptr [ebp - 0x9b6], 0
            //   75ae                 | jne                 0xffffffb0
            //   c78544f6ffff00000000     | mov    dword ptr [ebp - 0x9bc], 0
            //   eb0b                 | jmp                 0xd

        $sequence_7 = { 8b954cf6ffff 8a4201 88854af6ffff 8b8d50f6ffff 3a4101 7523 }
            // n = 6, score = 300
            //   8b954cf6ffff         | mov                 edx, dword ptr [ebp - 0x9b4]
            //   8a4201               | mov                 al, byte ptr [edx + 1]
            //   88854af6ffff         | mov                 byte ptr [ebp - 0x9b6], al
            //   8b8d50f6ffff         | mov                 ecx, dword ptr [ebp - 0x9b0]
            //   3a4101               | cmp                 al, byte ptr [ecx + 1]
            //   7523                 | jne                 0x25

        $sequence_8 = { 898dd0feffff 8b5508 0395d0feffff 0fbe42ff }
            // n = 4, score = 300
            //   898dd0feffff         | mov                 dword ptr [ebp - 0x130], ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0395d0feffff         | add                 edx, dword ptr [ebp - 0x130]
            //   0fbe42ff             | movsx               eax, byte ptr [edx - 1]

        $sequence_9 = { 3355fc 81e2ff000000 c1e217 0bca 894d14 }
            // n = 5, score = 200
            //   3355fc               | xor                 edx, dword ptr [ebp - 4]
            //   81e2ff000000         | and                 edx, 0xff
            //   c1e217               | shl                 edx, 0x17
            //   0bca                 | or                  ecx, edx
            //   894d14               | mov                 dword ptr [ebp + 0x14], ecx

        $sequence_10 = { 894518 8b5514 8955f8 8b4518 }
            // n = 4, score = 200
            //   894518               | mov                 dword ptr [ebp + 0x18], eax
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]

        $sequence_11 = { 33d0 8b4df8 c1e908 234df8 8b45f8 c1e810 23c8 }
            // n = 7, score = 200
            //   33d0                 | xor                 edx, eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   c1e908               | shr                 ecx, 8
            //   234df8               | and                 ecx, dword ptr [ebp - 8]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c1e810               | shr                 eax, 0x10
            //   23c8                 | and                 ecx, eax

        $sequence_12 = { 7412 837d0800 740c 837d0c00 7406 837d1408 }
            // n = 6, score = 200
            //   7412                 | je                  0x14
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   740c                 | je                  0xe
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   7406                 | je                  8
            //   837d1408             | cmp                 dword ptr [ebp + 0x14], 8

        $sequence_13 = { 0fb602 0fb64df7 33c1 0fb655fc 33c2 8b4d0c }
            // n = 6, score = 200
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   0fb64df7             | movzx               ecx, byte ptr [ebp - 9]
            //   33c1                 | xor                 eax, ecx
            //   0fb655fc             | movzx               edx, byte ptr [ebp - 4]
            //   33c2                 | xor                 eax, edx
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_14 = { 8b4d0c 034df0 8801 0fb655f7 2355fc }
            // n = 5, score = 200
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]
            //   8801                 | mov                 byte ptr [ecx], al
            //   0fb655f7             | movzx               edx, byte ptr [ebp - 9]
            //   2355fc               | and                 edx, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 1736704
}