rule win_dyepack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dyepack."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dyepack"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4c2410 33ed 33ff 3bc3 }
            // n = 4, score = 300
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   33ed                 | xor                 ebp, ebp
            //   33ff                 | xor                 edi, edi
            //   3bc3                 | cmp                 eax, ebx

        $sequence_1 = { ff15???????? 8b8c2428100000 53 51 e8???????? 83c408 5d }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   8b8c2428100000       | mov                 ecx, dword ptr [esp + 0x1028]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5d                   | pop                 ebp

        $sequence_2 = { 8d4c2418 53 51 8d54242c }
            // n = 4, score = 300
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   8d54242c             | lea                 edx, [esp + 0x2c]

        $sequence_3 = { 8d44242c 51 50 56 ff15???????? 85c0 }
            // n = 6, score = 300
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_4 = { 53 52 8d44242c 51 50 56 ff15???????? }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   52                   | push                edx
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_5 = { 6a03 53 aa 8b842434100000 53 6800000040 50 }
            // n = 7, score = 300
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8b842434100000       | mov                 eax, dword ptr [esp + 0x1034]
            //   53                   | push                ebx
            //   6800000040           | push                0x40000000
            //   50                   | push                eax

        $sequence_6 = { 3bf8 7cb2 7f08 8b4c2410 3be9 72ac 56 }
            // n = 7, score = 300
            //   3bf8                 | cmp                 edi, eax
            //   7cb2                 | jl                  0xffffffb4
            //   7f08                 | jg                  0xa
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   3be9                 | cmp                 ebp, ecx
            //   72ac                 | jb                  0xffffffae
            //   56                   | push                esi

        $sequence_7 = { 8b842434100000 53 6800000040 50 ff15???????? 8bf0 }
            // n = 6, score = 300
            //   8b842434100000       | mov                 eax, dword ptr [esp + 0x1034]
            //   53                   | push                ebx
            //   6800000040           | push                0x40000000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_8 = { 52 56 ff15???????? 56 ff15???????? 8d442410 895c2410 }
            // n = 7, score = 300
            //   52                   | push                edx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx

        $sequence_9 = { ff15???????? 56 ff15???????? 8d442410 895c2410 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx

    condition:
        7 of them and filesize < 212992
}