rule win_dyre_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dyre."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dyre"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800004000 6800000400 ff15???????? a3???????? 85c0 }
            // n = 5, score = 700
            //   6800004000           | push                0x400000
            //   6800000400           | push                0x40000
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { 83c9ff 2bc8 8bd0 c1fa02 }
            // n = 4, score = 600
            //   83c9ff               | or                  ecx, 0xffffffff
            //   2bc8                 | sub                 ecx, eax
            //   8bd0                 | mov                 edx, eax
            //   c1fa02               | sar                 edx, 2

        $sequence_2 = { 85c0 75f2 5d c3 33c0 40 }
            // n = 6, score = 600
            //   85c0                 | test                eax, eax
            //   75f2                 | jne                 0xfffffff4
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_3 = { 0fb6c9 0bca 8a5001 c1e108 0fb6d2 }
            // n = 5, score = 600
            //   0fb6c9               | movzx               ecx, cl
            //   0bca                 | or                  ecx, edx
            //   8a5001               | mov                 dl, byte ptr [eax + 1]
            //   c1e108               | shl                 ecx, 8
            //   0fb6d2               | movzx               edx, dl

        $sequence_4 = { e8???????? 85c0 74df 33c0 40 5e }
            // n = 6, score = 600
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   74df                 | je                  0xffffffe1
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5e                   | pop                 esi

        $sequence_5 = { 85c0 7502 c9 c3 33c0 837dfc20 }
            // n = 6, score = 600
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   c9                   | leave               
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   837dfc20             | cmp                 dword ptr [ebp - 4], 0x20

        $sequence_6 = { 8b4508 ff7514 53 ff30 e8???????? }
            // n = 5, score = 600
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   53                   | push                ebx
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     

        $sequence_7 = { 53 8bf8 e8???????? 59 5b 8bc7 5f }
            // n = 7, score = 600
            //   53                   | push                ebx
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi

        $sequence_8 = { 440fb69c249f000000 0fb68c249d000000 0fb694249c000000 440fb694249b000000 }
            // n = 4, score = 500
            //   440fb69c249f000000     | inc    esp
            //   0fb68c249d000000     | movzx               ebx, byte ptr [esp + 0x9f]
            //   0fb694249c000000     | movzx               ecx, byte ptr [esp + 0x9d]
            //   440fb694249b000000     | movzx    edx, byte ptr [esp + 0x9c]

        $sequence_9 = { 4433c0 418bc4 418bd3 c1c806 4433c0 8bc5 }
            // n = 6, score = 500
            //   4433c0               | inc                 ecx
            //   418bc4               | movzx               edx, byte ptr [ecx]
            //   418bd3               | inc                 ebp
            //   c1c806               | movzx               eax, byte ptr [ecx + 1]
            //   4433c0               | shl                 ecx, 8
            //   8bc5                 | inc                 ecx

        $sequence_10 = { 488bc8 ff15???????? 85c0 7455 4c8d442434 }
            // n = 5, score = 500
            //   488bc8               | mov                 ecx, ebx
            //   ff15????????         |                     
            //   85c0                 | dec                 esp
            //   7455                 | lea                 ebx, [esi + 1]
            //   4c8d442434           | inc                 ecx

        $sequence_11 = { 488bcb e8???????? 4c8d5e01 41b8f7ffffff 6666660f1f840000000000 488bcf }
            // n = 6, score = 500
            //   488bcb               | cmp                 dword ptr [edi + 4], eax
            //   e8????????           |                     
            //   4c8d5e01             | jne                 0x2d
            //   41b8f7ffffff         | dec                 eax
            //   6666660f1f840000000000     | mov    ecx, ebx
            //   488bcf               | dec                 esp

        $sequence_12 = { 663907 7530 8b4604 394704 7528 8b4608 394708 }
            // n = 7, score = 500
            //   663907               | inc                 esp
            //   7530                 | movzx               edx, byte ptr [esp + 0x9b]
            //   8b4604               | cmp                 word ptr [edi], ax
            //   394704               | jne                 0x32
            //   7528                 | mov                 eax, dword ptr [esi + 4]
            //   8b4608               | cmp                 dword ptr [edi + 4], eax
            //   394708               | jne                 0x2d

        $sequence_13 = { 410fb649fe c1e208 440bc2 41c1e008 410bc8 49ffca 43894c0bd3 }
            // n = 7, score = 500
            //   410fb649fe           | dec                 esp
            //   c1e208               | lea                 ebx, [esi + 1]
            //   440bc2               | inc                 ecx
            //   41c1e008             | mov                 eax, 0xfffffff7
            //   410bc8               | dec                 eax
            //   49ffca               | mov                 ecx, eax
            //   43894c0bd3           | test                eax, eax

        $sequence_14 = { 4433c0 418bc4 4123c5 33c8 8bc3 4403c1 418bcb }
            // n = 7, score = 500
            //   4433c0               | movzx               ecx, byte ptr [ecx - 1]
            //   418bc4               | inc                 ecx
            //   4123c5               | movzx               edx, byte ptr [ecx]
            //   33c8                 | inc                 ebp
            //   8bc3                 | movzx               eax, byte ptr [ecx + 1]
            //   4403c1               | shl                 ecx, 8
            //   418bcb               | dec                 ecx

        $sequence_15 = { 410fb649ff 410fb611 450fb64101 c1e108 }
            // n = 4, score = 500
            //   410fb649ff           | je                  0x59
            //   410fb611             | dec                 esp
            //   450fb64101           | lea                 eax, [esp + 0x34]
            //   c1e108               | cmp                 word ptr [edi], ax

        $sequence_16 = { 668b1401 668910 83c002 4e }
            // n = 4, score = 400
            //   668b1401             | mov                 dx, word ptr [ecx + eax]
            //   668910               | mov                 word ptr [eax], dx
            //   83c002               | add                 eax, 2
            //   4e                   | dec                 esi

        $sequence_17 = { 90 ff15???????? 8a0437 8806 46 4b }
            // n = 6, score = 200
            //   90                   | nop                 
            //   ff15????????         |                     
            //   8a0437               | mov                 al, byte ptr [edi + esi]
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi
            //   4b                   | dec                 ebx

        $sequence_18 = { ff15???????? 8bf0 8d85d4fdffff 50 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]
            //   50                   | push                eax

        $sequence_19 = { 833d????????00 751b 6a00 6800004000 }
            // n = 4, score = 200
            //   833d????????00       |                     
            //   751b                 | jne                 0x1d
            //   6a00                 | push                0
            //   6800004000           | push                0x400000

        $sequence_20 = { a1???????? 6a08 50 ff15???????? 8bd8 }
            // n = 5, score = 200
            //   a1????????           |                     
            //   6a08                 | push                8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_21 = { 8bf1 85db 7416 57 8bfa }
            // n = 5, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   85db                 | test                ebx, ebx
            //   7416                 | je                  0x18
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx

        $sequence_22 = { 57 8bfa 2bfe 90 ff15???????? }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   2bfe                 | sub                 edi, esi
            //   90                   | nop                 
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 590848
}