rule win_electricfish_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.electricfish."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.electricfish"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4f 783b 8bff 0fbe5500 40 8d0cb6 45 }
            // n = 7, score = 1200
            //   4f                   | dec                 edi
            //   783b                 | js                  0x3d
            //   8bff                 | mov                 edi, edi
            //   0fbe5500             | movsx               edx, byte ptr [ebp]
            //   40                   | inc                 eax
            //   8d0cb6               | lea                 ecx, [esi + esi*4]
            //   45                   | inc                 ebp

        $sequence_1 = { c3 8b4e0c 6a00 51 e8???????? 83c408 8b5608 }
            // n = 7, score = 1200
            //   c3                   | ret                 
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b5608               | mov                 edx, dword ptr [esi + 8]

        $sequence_2 = { 85ff 7411 8bc5 2bc6 50 03ce }
            // n = 6, score = 1200
            //   85ff                 | test                edi, edi
            //   7411                 | je                  0x13
            //   8bc5                 | mov                 eax, ebp
            //   2bc6                 | sub                 eax, esi
            //   50                   | push                eax
            //   03ce                 | add                 ecx, esi

        $sequence_3 = { 39a8ac000000 0f84a8000000 80beed0a000000 89aef00a0000 0f8564040000 80beee0a000000 }
            // n = 6, score = 1200
            //   39a8ac000000         | cmp                 dword ptr [eax + 0xac], ebp
            //   0f84a8000000         | je                  0xae
            //   80beed0a000000       | cmp                 byte ptr [esi + 0xaed], 0
            //   89aef00a0000         | mov                 dword ptr [esi + 0xaf0], ebp
            //   0f8564040000         | jne                 0x46a
            //   80beee0a000000       | cmp                 byte ptr [esi + 0xaee], 0

        $sequence_4 = { 0f85b8000000 85db 0f8451040000 0fb638 40 4b 4e }
            // n = 7, score = 1200
            //   0f85b8000000         | jne                 0xbe
            //   85db                 | test                ebx, ebx
            //   0f8451040000         | je                  0x457
            //   0fb638               | movzx               edi, byte ptr [eax]
            //   40                   | inc                 eax
            //   4b                   | dec                 ebx
            //   4e                   | dec                 esi

        $sequence_5 = { e8???????? 8b561c 68???????? 52 e8???????? 6893010000 68???????? }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   8b561c               | mov                 edx, dword ptr [esi + 0x1c]
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   6893010000           | push                0x193
            //   68????????           |                     

        $sequence_6 = { e8???????? 8b4614 89780c 8b4b14 8b5110 52 e8???????? }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   89780c               | mov                 dword ptr [eax + 0xc], edi
            //   8b4b14               | mov                 ecx, dword ptr [ebx + 0x14]
            //   8b5110               | mov                 edx, dword ptr [ecx + 0x10]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_7 = { e8???????? 83c418 85c0 0f8413030000 8b542410 52 8d442464 }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   0f8413030000         | je                  0x319
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   52                   | push                edx
            //   8d442464             | lea                 eax, [esp + 0x64]

        $sequence_8 = { 0f84d3000000 8b879c010000 3bc3 7417 50 e8???????? 83c404 }
            // n = 7, score = 1200
            //   0f84d3000000         | je                  0xd9
            //   8b879c010000         | mov                 eax, dword ptr [edi + 0x19c]
            //   3bc3                 | cmp                 eax, ebx
            //   7417                 | je                  0x19
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_9 = { c3 8b8424a8000000 6a01 50 e8???????? 83c408 5b }
            // n = 7, score = 1200
            //   c3                   | ret                 
            //   8b8424a8000000       | mov                 eax, dword ptr [esp + 0xa8]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5b                   | pop                 ebx

    condition:
        7 of them and filesize < 3162112
}