rule win_emudbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.emudbot"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83bd70ffffff05 7517 83bd74ffffff01 750e 8bc3 ba???????? }
            // n = 6, score = 300
            //   83bd70ffffff05       | cmp                 dword ptr [ebp - 0x90], 5
            //   7517                 | jne                 0x19
            //   83bd74ffffff01       | cmp                 dword ptr [ebp - 0x8c], 1
            //   750e                 | jne                 0x10
            //   8bc3                 | mov                 eax, ebx
            //   ba????????           |                     

        $sequence_1 = { e8???????? 897dcc 83ec04 895c2408 897c2404 8b9e44100000 891c24 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   897dcc               | mov                 dword ptr [ebp - 0x34], edi
            //   83ec04               | sub                 esp, 4
            //   895c2408             | mov                 dword ptr [esp + 8], ebx
            //   897c2404             | mov                 dword ptr [esp + 4], edi
            //   8b9e44100000         | mov                 ebx, dword ptr [esi + 0x1044]
            //   891c24               | mov                 dword ptr [esp], ebx

        $sequence_2 = { 648920 8d45fc 8b4dfc ba???????? e8???????? }
            // n = 5, score = 300
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   ba????????           |                     
            //   e8????????           |                     

        $sequence_3 = { e8???????? eb78 e8???????? 8bd0 8d45e8 e8???????? }
            // n = 6, score = 300
            //   e8????????           |                     
            //   eb78                 | jmp                 0x7a
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   e8????????           |                     

        $sequence_4 = { c1ea0b 33c2 8bd0 c1e20f 03c2 }
            // n = 5, score = 300
            //   c1ea0b               | shr                 edx, 0xb
            //   33c2                 | xor                 eax, edx
            //   8bd0                 | mov                 edx, eax
            //   c1e20f               | shl                 edx, 0xf
            //   03c2                 | add                 eax, edx

        $sequence_5 = { 8bd0 42 8d85fbfeffff b904010000 e8???????? 8bc6 8b15???????? }
            // n = 7, score = 300
            //   8bd0                 | mov                 edx, eax
            //   42                   | inc                 edx
            //   8d85fbfeffff         | lea                 eax, [ebp - 0x105]
            //   b904010000           | mov                 ecx, 0x104
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   8b15????????         |                     

        $sequence_6 = { 8bca 890424 8bc1 33d2 52 50 8d442408 }
            // n = 7, score = 300
            //   8bca                 | mov                 ecx, edx
            //   890424               | mov                 dword ptr [esp], eax
            //   8bc1                 | mov                 eax, ecx
            //   33d2                 | xor                 edx, edx
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d442408             | lea                 eax, [esp + 8]

        $sequence_7 = { 6a01 6a01 50 e8???????? 8bd8 85db 0f8689000000 }
            // n = 7, score = 300
            //   6a01                 | push                1
            //   6a01                 | push                1
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   0f8689000000         | jbe                 0x8f

        $sequence_8 = { c645fc13 8b550c 894c2408 8845fd 8b4508 8955f8 }
            // n = 6, score = 300
            //   c645fc13             | mov                 byte ptr [ebp - 4], 0x13
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   8845fd               | mov                 byte ptr [ebp - 3], al
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_9 = { 8d5dd8 89442404 8bbe40100000 be01000000 893c24 e8???????? }
            // n = 6, score = 300
            //   8d5dd8               | lea                 ebx, [ebp - 0x28]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8bbe40100000         | mov                 edi, dword ptr [esi + 0x1040]
            //   be01000000           | mov                 esi, 1
            //   893c24               | mov                 dword ptr [esp], edi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 221184
}