rule win_fakeword_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fakeword."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fakeword"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 68fa0f0000 57 55 ff15???????? 8b4c2410 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   68fa0f0000           | push                0xffa
            //   57                   | push                edi
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_1 = { 85c9 7445 33c0 85c9 7623 8b3d???????? }
            // n = 6, score = 200
            //   85c9                 | test                ecx, ecx
            //   7445                 | je                  0x47
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   7623                 | jbe                 0x25
            //   8b3d????????         |                     

        $sequence_2 = { 8b442408 56 57 8d7001 56 ff15???????? 85c0 }
            // n = 7, score = 200
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d7001               | lea                 esi, [eax + 1]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 85d2 7405 46 89742424 0fafce 6a40 6800100000 }
            // n = 7, score = 200
            //   85d2                 | test                edx, edx
            //   7405                 | je                  7
            //   46                   | inc                 esi
            //   89742424             | mov                 dword ptr [esp + 0x24], esi
            //   0fafce               | imul                ecx, esi
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000

        $sequence_4 = { e8???????? 8b0d???????? 83c40c 83c704 6a00 57 56 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   83c704               | add                 edi, 4
            //   6a00                 | push                0
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_5 = { 8b3d???????? 83c40c 68???????? 56 ffd7 8d54240c }
            // n = 6, score = 200
            //   8b3d????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8d54240c             | lea                 edx, [esp + 0xc]

        $sequence_6 = { 8b15???????? 892d???????? 3bd3 7f1a }
            // n = 4, score = 200
            //   8b15????????         |                     
            //   892d????????         |                     
            //   3bd3                 | cmp                 edx, ebx
            //   7f1a                 | jg                  0x1c

        $sequence_7 = { 2bc7 3d20010000 7f0e 83f812 0f8e0d010000 ba01000000 89542440 }
            // n = 7, score = 200
            //   2bc7                 | sub                 eax, edi
            //   3d20010000           | cmp                 eax, 0x120
            //   7f0e                 | jg                  0x10
            //   83f812               | cmp                 eax, 0x12
            //   0f8e0d010000         | jle                 0x113
            //   ba01000000           | mov                 edx, 1
            //   89542440             | mov                 dword ptr [esp + 0x40], edx

        $sequence_8 = { 5b 83c44c c3 56 57 6a00 e8???????? }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   83c44c               | add                 esp, 0x4c
            //   c3                   | ret                 
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_9 = { ffd6 8d8c2418010000 68???????? 51 ffd6 893d???????? 8b03 }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   8d8c2418010000       | lea                 ecx, [esp + 0x118]
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   893d????????         |                     
            //   8b03                 | mov                 eax, dword ptr [ebx]

    condition:
        7 of them and filesize < 98304
}