rule win_final1stspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.final1stspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.final1stspy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a7201 8ad3 3ad6 7412 8a5101 41 84d2 }
            // n = 7, score = 300
            //   8a7201               | mov                 dh, byte ptr [edx + 1]
            //   8ad3                 | mov                 dl, bl
            //   3ad6                 | cmp                 dl, dh
            //   7412                 | je                  0x14
            //   8a5101               | mov                 dl, byte ptr [ecx + 1]
            //   41                   | inc                 ecx
            //   84d2                 | test                dl, dl

        $sequence_1 = { 46 8a1d???????? 83ff02 7d0e 8bc2 }
            // n = 5, score = 300
            //   46                   | inc                 esi
            //   8a1d????????         |                     
            //   83ff02               | cmp                 edi, 2
            //   7d0e                 | jge                 0x10
            //   8bc2                 | mov                 eax, edx

        $sequence_2 = { 5d c3 2d???????? 78dc }
            // n = 4, score = 300
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   2d????????           |                     
            //   78dc                 | js                  0xffffffde

        $sequence_3 = { 881439 41 3bce 7cef 8bc7 }
            // n = 5, score = 300
            //   881439               | mov                 byte ptr [ecx + edi], dl
            //   41                   | inc                 ecx
            //   3bce                 | cmp                 ecx, esi
            //   7cef                 | jl                  0xfffffff1
            //   8bc7                 | mov                 eax, edi

        $sequence_4 = { 84db 75f4 5f 5e 83c8ff 5b 8be5 }
            // n = 7, score = 300
            //   84db                 | test                bl, bl
            //   75f4                 | jne                 0xfffffff6
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c8ff               | or                  eax, 0xffffffff
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_5 = { 8bc8 83c404 894df8 8bf1 8b4dfc 803900 7426 }
            // n = 7, score = 300
            //   8bc8                 | mov                 ecx, eax
            //   83c404               | add                 esp, 4
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8bf1                 | mov                 esi, ecx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   803900               | cmp                 byte ptr [ecx], 0
            //   7426                 | je                  0x28

        $sequence_6 = { bf01000000 eb2b b8???????? 8acb }
            // n = 4, score = 300
            //   bf01000000           | mov                 edi, 1
            //   eb2b                 | jmp                 0x2d
            //   b8????????           |                     
            //   8acb                 | mov                 cl, bl

        $sequence_7 = { 3bf7 7cf6 8b3d???????? 66660f1f840000000000 }
            // n = 4, score = 300
            //   3bf7                 | cmp                 esi, edi
            //   7cf6                 | jl                  0xfffffff8
            //   8b3d????????         |                     
            //   66660f1f840000000000     | nop    word ptr [eax + eax]

        $sequence_8 = { 6690 3acd 7412 8a4801 40 84c9 }
            // n = 6, score = 300
            //   6690                 | nop                 
            //   3acd                 | cmp                 cl, ch
            //   7412                 | je                  0x14
            //   8a4801               | mov                 cl, byte ptr [eax + 1]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl

        $sequence_9 = { 7d11 8a1439 80c27a 80f219 881439 41 }
            // n = 6, score = 300
            //   7d11                 | jge                 0x13
            //   8a1439               | mov                 dl, byte ptr [ecx + edi]
            //   80c27a               | add                 dl, 0x7a
            //   80f219               | xor                 dl, 0x19
            //   881439               | mov                 byte ptr [ecx + edi], dl
            //   41                   | inc                 ecx

    condition:
        7 of them and filesize < 557056
}