rule win_firechili_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.firechili."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.firechili"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 488d6c24b1 4881ec98000000 48894d17 4c8d4507 }
            // n = 5, score = 100
            //   53                   | mov                 dword ptr [esp + 0x50], edx
            //   488d6c24b1           | dec                 eax
            //   4881ec98000000       | test                ecx, ecx
            //   48894d17             | inc                 ecx
            //   4c8d4507             | mov                 ebp, edx

        $sequence_1 = { 4885c0 745a 483bc3 7455 }
            // n = 4, score = 100
            //   4885c0               | dec                 eax
            //   745a                 | lea                 eax, [esp + 0x40]
            //   483bc3               | dec                 ecx
            //   7455                 | lea                 ecx, [ecx + edx]

        $sequence_2 = { 0f114fb0 0f1043c0 0f1147c0 0f104bd0 0f114fd0 0f1043e0 0f1147e0 }
            // n = 7, score = 100
            //   0f114fb0             | inc                 esp
            //   0f1043c0             | movzx               eax, word ptr [ecx + 2]
            //   0f1147c0             | inc                 ecx
            //   0f104bd0             | test                al, 1
            //   0f114fd0             | inc                 ecx
            //   0f1043e0             | mov                 ebx, esi
            //   0f1147e0             | dec                 eax

        $sequence_3 = { 4c8d4507 4889450f 488d4d7f 488d45f7 48897c2430 0f57c0 897c2428 }
            // n = 7, score = 100
            //   4c8d4507             | mov                 edi, ebx
            //   4889450f             | dec                 eax
            //   488d4d7f             | mov                 ebp, edx
            //   488d45f7             | dec                 eax
            //   48897c2430           | shr                 ebp, 4
            //   0f57c0               | dec                 eax
            //   897c2428             | test                ebp, ebp

        $sequence_4 = { 7c6c 488b4840 4885c9 742d f6410a05 7406 488b4118 }
            // n = 7, score = 100
            //   7c6c                 | mov                 ecx, esi
            //   488b4840             | nop                 
            //   4885c9               | dec                 eax
            //   742d                 | test                edi, edi
            //   f6410a05             | mov                 word ptr [esp + 0x32], bp
            //   7406                 | dec                 eax
            //   488b4118             | mov                 ecx, edi

        $sequence_5 = { e8???????? 488b7c2428 0fb6f0 4885ff 744f }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488b7c2428           | mov                 dword ptr [ebp + 0x37], eax
            //   0fb6f0               | dec                 eax
            //   4885ff               | mov                 dword ptr [ebp + 0x3f], eax
            //   744f                 | dec                 eax

        $sequence_6 = { 664585db 750c 410fb7d0 488bcb 48d1ea eb05 b80d0000c0 }
            // n = 7, score = 100
            //   664585db             | mov                 dword ptr [esp + 0x38], esi
            //   750c                 | dec                 esp
            //   410fb7d0             | mov                 dword ptr [esp + 0x30], esi
            //   488bcb               | test                dl, 4
            //   48d1ea               | je                  0x1a0e
            //   eb05                 | xor                 eax, eax
            //   b80d0000c0           | dec                 esp

        $sequence_7 = { 3c02 773d ff05???????? 488d0da7490000 ff15???????? }
            // n = 5, score = 100
            //   3c02                 | je                  0xca6
            //   773d                 | inc                 ecx
            //   ff05????????         |                     
            //   488d0da7490000       | cmp                 eax, 0x840766c1
            //   ff15????????         |                     

        $sequence_8 = { 0f8420010000 4883feff 0f840d010000 488d8424a0000000 48895c2428 4533c9 }
            // n = 6, score = 100
            //   0f8420010000         | mov                 dword ptr [ecx + 8], eax
            //   4883feff             | dec                 eax
            //   0f840d010000         | mov                 ecx, ebx
            //   488d8424a0000000     | dec                 eax
            //   48895c2428           | mov                 eax, dword ptr [ebx + 8]
            //   4533c9               | dec                 eax

        $sequence_9 = { 488d0d7d490000 ff15???????? 488b7c2430 33c0 48894308 }
            // n = 5, score = 100
            //   488d0d7d490000       | je                  0x1ee
            //   ff15????????         |                     
            //   488b7c2430           | inc                 ecx
            //   33c0                 | mov                 eax, 0x210
            //   48894308             | dec                 eax

    condition:
        7 of them and filesize < 91136
}