rule win_fk_undead_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fk_undead."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fk_undead"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 741e 8d4c2428 51 8b4c2424 8d542428 52 56 }
            // n = 7, score = 100
            //   741e                 | je                  0x20
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   51                   | push                ecx
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   52                   | push                edx
            //   56                   | push                esi

        $sequence_1 = { 81c2fcff0000 3bd6 7303 894d00 8b4500 33c9 668908 }
            // n = 7, score = 100
            //   81c2fcff0000         | add                 edx, 0xfffc
            //   3bd6                 | cmp                 edx, esi
            //   7303                 | jae                 5
            //   894d00               | mov                 dword ptr [ebp], ecx
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   33c9                 | xor                 ecx, ecx
            //   668908               | mov                 word ptr [eax], cx

        $sequence_2 = { 0f8290000000 81394e544c4d 0f8584000000 81790453535000 757b 8b4108 3b05???????? }
            // n = 7, score = 100
            //   0f8290000000         | jb                  0x96
            //   81394e544c4d         | cmp                 dword ptr [ecx], 0x4d4c544e
            //   0f8584000000         | jne                 0x8a
            //   81790453535000       | cmp                 dword ptr [ecx + 4], 0x505353
            //   757b                 | jne                 0x7d
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   3b05????????         |                     

        $sequence_3 = { eb2b 8b54242c 68???????? 68???????? 68???????? 68???????? 55 }
            // n = 7, score = 100
            //   eb2b                 | jmp                 0x2d
            //   8b54242c             | mov                 edx, dword ptr [esp + 0x2c]
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   55                   | push                ebp

        $sequence_4 = { e8???????? 8b0b 8d042f 66894114 8b13 b81c000000 66894216 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   8d042f               | lea                 eax, [edi + ebp]
            //   66894114             | mov                 word ptr [ecx + 0x14], ax
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   b81c000000           | mov                 eax, 0x1c
            //   66894216             | mov                 word ptr [edx + 0x16], ax

        $sequence_5 = { 3a5608 7514 0fb74616 0fb74f16 03c6 50 03cf }
            // n = 7, score = 100
            //   3a5608               | cmp                 dl, byte ptr [esi + 8]
            //   7514                 | jne                 0x16
            //   0fb74616             | movzx               eax, word ptr [esi + 0x16]
            //   0fb74f16             | movzx               ecx, word ptr [edi + 0x16]
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   03cf                 | add                 ecx, edi

        $sequence_6 = { 52 50 33ff 51 897c2420 e8???????? 8b5c2420 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   50                   | push                eax
            //   33ff                 | xor                 edi, edi
            //   51                   | push                ecx
            //   897c2420             | mov                 dword ptr [esp + 0x20], edi
            //   e8????????           |                     
            //   8b5c2420             | mov                 ebx, dword ptr [esp + 0x20]

        $sequence_7 = { 57 6812270000 56 e8???????? 6a00 682c4e0000 56 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6812270000           | push                0x2712
            //   56                   | push                esi
            //   e8????????           |                     
            //   6a00                 | push                0
            //   682c4e0000           | push                0x4e2c
            //   56                   | push                esi

        $sequence_8 = { 8906 33c0 c7466428e40410 c7466800000000 c7466c00000000 c7464000000000 c7869800000000000000 }
            // n = 7, score = 100
            //   8906                 | mov                 dword ptr [esi], eax
            //   33c0                 | xor                 eax, eax
            //   c7466428e40410       | mov                 dword ptr [esi + 0x64], 0x1004e428
            //   c7466800000000       | mov                 dword ptr [esi + 0x68], 0
            //   c7466c00000000       | mov                 dword ptr [esi + 0x6c], 0
            //   c7464000000000       | mov                 dword ptr [esi + 0x40], 0
            //   c7869800000000000000     | mov    dword ptr [esi + 0x98], 0

        $sequence_9 = { 7414 8bd1 c1f805 83e21f c1e206 031485e0650a10 eb02 }
            // n = 7, score = 100
            //   7414                 | je                  0x16
            //   8bd1                 | mov                 edx, ecx
            //   c1f805               | sar                 eax, 5
            //   83e21f               | and                 edx, 0x1f
            //   c1e206               | shl                 edx, 6
            //   031485e0650a10       | add                 edx, dword ptr [eax*4 + 0x100a65e0]
            //   eb02                 | jmp                 4

    condition:
        7 of them and filesize < 1418240
}