rule win_flawedammyy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.flawedammyy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flawedammyy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd7 8d85fcfeffff 50 8d85ccf2ffff 68???????? }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   8d85ccf2ffff         | lea                 eax, [ebp - 0xd34]
            //   68????????           |                     

        $sequence_1 = { 0022 8a4200 828a4200bb8a42 00ff }
            // n = 4, score = 200
            //   0022                 | add                 byte ptr [edx], ah
            //   8a4200               | mov                 al, byte ptr [edx]
            //   828a4200bb8a42       | or                  byte ptr [edx - 0x7544ffbe], 0x42
            //   00ff                 | add                 bh, bh

        $sequence_2 = { 004bbf 42 0062bf 42 }
            // n = 4, score = 200
            //   004bbf               | add                 byte ptr [ebx - 0x41], cl
            //   42                   | inc                 edx
            //   0062bf               | add                 byte ptr [edx - 0x41], ah
            //   42                   | inc                 edx

        $sequence_3 = { 8d85bcfdffff 50 ffd3 8b45fc }
            // n = 4, score = 200
            //   8d85bcfdffff         | lea                 eax, [ebp - 0x244]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_4 = { 8d8548ffffff 6a00 50 660fd645ac 660fd645b4 e8???????? }
            // n = 6, score = 200
            //   8d8548ffffff         | lea                 eax, [ebp - 0xb8]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   660fd645ac           | movq                qword ptr [ebp - 0x54], xmm0
            //   660fd645b4           | movq                qword ptr [ebp - 0x4c], xmm0
            //   e8????????           |                     

        $sequence_5 = { 68???????? 6a00 6a00 ff15???????? 8b3d???????? 6830750000 ffd7 }
            // n = 7, score = 200
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   6830750000           | push                0x7530
            //   ffd7                 | call                edi

        $sequence_6 = { 66898534ffffff ffd7 85c0 750f 68???????? ffd7 }
            // n = 6, score = 200
            //   66898534ffffff       | mov                 word ptr [ebp - 0xcc], ax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   68????????           |                     
            //   ffd7                 | call                edi

        $sequence_7 = { 0000 0404 0404 0404 0401 }
            // n = 5, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0404                 | add                 al, 4
            //   0404                 | add                 al, 4
            //   0404                 | add                 al, 4
            //   0401                 | add                 al, 1

        $sequence_8 = { 00b3854200e5 854200 37 864200 }
            // n = 4, score = 200
            //   00b3854200e5         | add                 byte ptr [ebx - 0x1affbd7b], dh
            //   854200               | test                dword ptr [edx], eax
            //   37                   | aaa                 
            //   864200               | xchg                byte ptr [edx], al

        $sequence_9 = { 85c0 782d 8b7dfc 2b7df4 8b7514 037d08 6a00 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   782d                 | js                  0x2f
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   2b7df4               | sub                 edi, dword ptr [ebp - 0xc]
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]
            //   037d08               | add                 edi, dword ptr [ebp + 8]
            //   6a00                 | push                0

        $sequence_10 = { 0018 874200 58 874200 }
            // n = 4, score = 200
            //   0018                 | add                 byte ptr [eax], bl
            //   874200               | xchg                dword ptr [edx], eax
            //   58                   | pop                 eax
            //   874200               | xchg                dword ptr [edx], eax

        $sequence_11 = { 0039 e342 0048e3 42 }
            // n = 4, score = 200
            //   0039                 | add                 byte ptr [ecx], bh
            //   e342                 | jecxz               0x44
            //   0048e3               | add                 byte ptr [eax - 0x1d], cl
            //   42                   | inc                 edx

        $sequence_12 = { ff15???????? 85c0 0f885e010000 6a00 6a00 6a00 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f885e010000         | js                  0x164
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_13 = { 002a e342 0039 e342 }
            // n = 4, score = 200
            //   002a                 | add                 byte ptr [edx], ch
            //   e342                 | jecxz               0x44
            //   0039                 | add                 byte ptr [ecx], bh
            //   e342                 | jecxz               0x44

        $sequence_14 = { ff75fc ff15???????? 85c0 740c 68???????? }
            // n = 5, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe
            //   68????????           |                     

        $sequence_15 = { 0062bf 42 0079bf 42 }
            // n = 4, score = 200
            //   0062bf               | add                 byte ptr [edx - 0x41], ah
            //   42                   | inc                 edx
            //   0079bf               | add                 byte ptr [ecx - 0x41], bh
            //   42                   | inc                 edx

        $sequence_16 = { 59 8945c4 eb17 68???????? 56 }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   eb17                 | jmp                 0x19
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_17 = { 8b04855c303400 c1e002 50 6a40 ff15???????? 8906 43 }
            // n = 7, score = 100
            //   8b04855c303400       | mov                 eax, dword ptr [eax*4 + 0x34305c]
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8906                 | mov                 dword ptr [esi], eax
            //   43                   | inc                 ebx

        $sequence_18 = { e9???????? 895df4 8d41de 33db 83f855 0f872affffff 0fb6805a213400 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   8d41de               | lea                 eax, [ecx - 0x22]
            //   33db                 | xor                 ebx, ebx
            //   83f855               | cmp                 eax, 0x55
            //   0f872affffff         | ja                  0xffffff30
            //   0fb6805a213400       | movzx               eax, byte ptr [eax + 0x34215a]

        $sequence_19 = { ff248580233400 832700 e9???????? 55 e8???????? eb1a 55 }
            // n = 7, score = 100
            //   ff248580233400       | jmp                 dword ptr [eax*4 + 0x342380]
            //   832700               | and                 dword ptr [edi], 0
            //   e9????????           |                     
            //   55                   | push                ebp
            //   e8????????           |                     
            //   eb1a                 | jmp                 0x1c
            //   55                   | push                ebp

        $sequence_20 = { ff15???????? 8b45f0 395d08 88987830ca01 0f8484010000 ff75fc }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   395d08               | cmp                 dword ptr [ebp + 8], ebx
            //   88987830ca01         | mov                 byte ptr [eax + 0x1ca3078], bl
            //   0f8484010000         | je                  0x18a
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_21 = { ff75fc e8???????? f6450801 7412 }
            // n = 4, score = 100
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   f6450801             | test                byte ptr [ebp + 8], 1
            //   7412                 | je                  0x14

        $sequence_22 = { ff15???????? 8b4dc8 03ce 3bc1 761f 6aff ff75a8 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   03ce                 | add                 ecx, esi
            //   3bc1                 | cmp                 eax, ecx
            //   761f                 | jbe                 0x21
            //   6aff                 | push                -1
            //   ff75a8               | push                dword ptr [ebp - 0x58]

        $sequence_23 = { e8???????? 8b4d08 8a0408 a2???????? eb07 c605????????00 c705????????4c403400 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8a0408               | mov                 al, byte ptr [eax + ecx]
            //   a2????????           |                     
            //   eb07                 | jmp                 9
            //   c605????????00       |                     
            //   c705????????4c403400     |     

        $sequence_24 = { 83f907 0f8781000000 ff248dfd243400 881f eb76 }
            // n = 5, score = 100
            //   83f907               | cmp                 ecx, 7
            //   0f8781000000         | ja                  0x87
            //   ff248dfd243400       | jmp                 dword ptr [ecx*4 + 0x3424fd]
            //   881f                 | mov                 byte ptr [edi], bl
            //   eb76                 | jmp                 0x78

        $sequence_25 = { 5e 5b c3 55 8bec 81ec5c040000 53 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec5c040000         | sub                 esp, 0x45c
            //   53                   | push                ebx

        $sequence_26 = { 894dfc eb0e 8b14957c303400 49 0fafd1 0155fc }
            // n = 6, score = 100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   eb0e                 | jmp                 0x10
            //   8b14957c303400       | mov                 edx, dword ptr [edx*4 + 0x34307c]
            //   49                   | dec                 ecx
            //   0fafd1               | imul                edx, ecx
            //   0155fc               | add                 dword ptr [ebp - 4], edx

        $sequence_27 = { 0f872affffff 0fb6805a213400 ff2485f6203400 8b8614080000 3b45f4 }
            // n = 5, score = 100
            //   0f872affffff         | ja                  0xffffff30
            //   0fb6805a213400       | movzx               eax, byte ptr [eax + 0x34215a]
            //   ff2485f6203400       | jmp                 dword ptr [eax*4 + 0x3420f6]
            //   8b8614080000         | mov                 eax, dword ptr [esi + 0x814]
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]

        $sequence_28 = { 895da8 ab ab ab ff15???????? }
            // n = 5, score = 100
            //   895da8               | mov                 dword ptr [ebp - 0x58], ebx
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ff15????????         |                     

        $sequence_29 = { 80bda4fbffff22 8d85a4fbffff 750a c645ff22 8d85a5fbffff 8b35???????? }
            // n = 6, score = 100
            //   80bda4fbffff22       | cmp                 byte ptr [ebp - 0x45c], 0x22
            //   8d85a4fbffff         | lea                 eax, [ebp - 0x45c]
            //   750a                 | jne                 0xc
            //   c645ff22             | mov                 byte ptr [ebp - 1], 0x22
            //   8d85a5fbffff         | lea                 eax, [ebp - 0x45b]
            //   8b35????????         |                     

        $sequence_30 = { ff75e0 ffd7 ff75cc ffd7 8d46fe 3b45f4 }
            // n = 6, score = 100
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ffd7                 | call                edi
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   ffd7                 | call                edi
            //   8d46fe               | lea                 eax, [esi - 2]
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]

        $sequence_31 = { 8bdf 8b06 83661c00 83f807 0f87c9000000 ff248580233400 }
            // n = 6, score = 100
            //   8bdf                 | mov                 ebx, edi
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83661c00             | and                 dword ptr [esi + 0x1c], 0
            //   83f807               | cmp                 eax, 7
            //   0f87c9000000         | ja                  0xcf
            //   ff248580233400       | jmp                 dword ptr [eax*4 + 0x342380]

    condition:
        7 of them and filesize < 1350656
}