rule win_floxif_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.floxif."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.floxif"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 50 8d4d84 e8???????? 83f8ff 0f85ac000000 6a00 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   8d4d84               | lea                 ecx, [ebp - 0x7c]
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f85ac000000         | jne                 0xb2
            //   6a00                 | push                0

        $sequence_1 = { 80a0405d021000 40 41 41 }
            // n = 4, score = 100
            //   80a0405d021000       | and                 byte ptr [eax + 0x10025d40], 0
            //   40                   | inc                 eax
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx

        $sequence_2 = { 8b55e0 8d440afc 50 8d4dc0 51 e8???????? }
            // n = 6, score = 100
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   8d440afc             | lea                 eax, [edx + ecx - 4]
            //   50                   | push                eax
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { 85c0 0f8677010000 c745a800000000 eb09 8b45a8 83c001 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f8677010000         | jbe                 0x17d
            //   c745a800000000       | mov                 dword ptr [ebp - 0x58], 0
            //   eb09                 | jmp                 0xb
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   83c001               | add                 eax, 1

        $sequence_4 = { f6c201 7416 8088????????10 8a9405ecfdffff 8890405d0210 eb1c }
            // n = 6, score = 100
            //   f6c201               | test                dl, 1
            //   7416                 | je                  0x18
            //   8088????????10       |                     
            //   8a9405ecfdffff       | mov                 dl, byte ptr [ebp + eax - 0x214]
            //   8890405d0210         | mov                 byte ptr [eax + 0x10025d40], dl
            //   eb1c                 | jmp                 0x1e

        $sequence_5 = { c645f2ac c645f392 c645f4b0 c645f5ab c645f6b4 }
            // n = 5, score = 100
            //   c645f2ac             | mov                 byte ptr [ebp - 0xe], 0xac
            //   c645f392             | mov                 byte ptr [ebp - 0xd], 0x92
            //   c645f4b0             | mov                 byte ptr [ebp - 0xc], 0xb0
            //   c645f5ab             | mov                 byte ptr [ebp - 0xb], 0xab
            //   c645f6b4             | mov                 byte ptr [ebp - 0xa], 0xb4

        $sequence_6 = { c6458f00 c64590e0 c64591ee c64592ec c64593eb c64594e8 c64595e8 }
            // n = 7, score = 100
            //   c6458f00             | mov                 byte ptr [ebp - 0x71], 0
            //   c64590e0             | mov                 byte ptr [ebp - 0x70], 0xe0
            //   c64591ee             | mov                 byte ptr [ebp - 0x6f], 0xee
            //   c64592ec             | mov                 byte ptr [ebp - 0x6e], 0xec
            //   c64593eb             | mov                 byte ptr [ebp - 0x6d], 0xeb
            //   c64594e8             | mov                 byte ptr [ebp - 0x6c], 0xe8
            //   c64595e8             | mov                 byte ptr [ebp - 0x6b], 0xe8

        $sequence_7 = { c705????????01000000 50 a3???????? e8???????? 8db60c0f0210 bf???????? a5 }
            // n = 7, score = 100
            //   c705????????01000000     |     
            //   50                   | push                eax
            //   a3????????           |                     
            //   e8????????           |                     
            //   8db60c0f0210         | lea                 esi, [esi + 0x10020f0c]
            //   bf????????           |                     
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_8 = { 50 8b4df0 e8???????? 8b4df0 8b55f0 8b410c 2b4204 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8b410c               | mov                 eax, dword ptr [ecx + 0xc]
            //   2b4204               | sub                 eax, dword ptr [edx + 4]

        $sequence_9 = { e9???????? 33d2 8a15???????? 83fa01 7514 c6458801 8d4df0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   33d2                 | xor                 edx, edx
            //   8a15????????         |                     
            //   83fa01               | cmp                 edx, 1
            //   7514                 | jne                 0x16
            //   c6458801             | mov                 byte ptr [ebp - 0x78], 1
            //   8d4df0               | lea                 ecx, [ebp - 0x10]

    condition:
        7 of them and filesize < 352256
}