rule win_fonix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fonix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fonix"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? e8???????? c3 83c1fc 8b01 ff504c 83c008 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   c3                   | ret                 
            //   83c1fc               | add                 ecx, -4
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff504c               | call                dword ptr [eax + 0x4c]
            //   83c008               | add                 eax, 8

        $sequence_1 = { 75f2 8b7518 8b4d20 8bc6 2bce 83e1c0 81f900100000 }
            // n = 7, score = 100
            //   75f2                 | jne                 0xfffffff4
            //   8b7518               | mov                 esi, dword ptr [ebp + 0x18]
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]
            //   8bc6                 | mov                 eax, esi
            //   2bce                 | sub                 ecx, esi
            //   83e1c0               | and                 ecx, 0xffffffc0
            //   81f900100000         | cmp                 ecx, 0x1000

        $sequence_2 = { 8d8d10ffffff e9???????? 8d8d98fbffff e9???????? 8d4da4 e9???????? }
            // n = 6, score = 100
            //   8d8d10ffffff         | lea                 ecx, [ebp - 0xf0]
            //   e9????????           |                     
            //   8d8d98fbffff         | lea                 ecx, [ebp - 0x468]
            //   e9????????           |                     
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   e9????????           |                     

        $sequence_3 = { 8bc6 5e 5d c20400 8b4948 6a01 }
            // n = 6, score = 100
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8b4948               | mov                 ecx, dword ptr [ecx + 0x48]
            //   6a01                 | push                1

        $sequence_4 = { c5fdef85e0fdffff c5fe7f85e0f9ffff c5fe6f85e0f9ffff c5fe7f4580 c5fe6f8560ffffff c5fdef85c0fdffff c5fe7f85c0f9ffff }
            // n = 7, score = 100
            //   c5fdef85e0fdffff     | vpxor               ymm0, ymm0, ymmword ptr [ebp - 0x220]
            //   c5fe7f85e0f9ffff     | vmovdqu             ymmword ptr [ebp - 0x620], ymm0
            //   c5fe6f85e0f9ffff     | vmovdqu             ymm0, ymmword ptr [ebp - 0x620]
            //   c5fe7f4580           | vmovdqu             ymmword ptr [ebp - 0x80], ymm0
            //   c5fe6f8560ffffff     | vmovdqu             ymm0, ymmword ptr [ebp - 0xa0]
            //   c5fdef85c0fdffff     | vpxor               ymm0, ymm0, ymmword ptr [ebp - 0x240]
            //   c5fe7f85c0f9ffff     | vmovdqu             ymmword ptr [ebp - 0x640], ymm0

        $sequence_5 = { 8d420c 8b4ae8 33c8 e8???????? b8???????? e9???????? 6a40 }
            // n = 7, score = 100
            //   8d420c               | lea                 eax, [edx + 0xc]
            //   8b4ae8               | mov                 ecx, dword ptr [edx - 0x18]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   b8????????           |                     
            //   e9????????           |                     
            //   6a40                 | push                0x40

        $sequence_6 = { 50 e8???????? cc 803d????????00 7505 e8???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   cc                   | int3                
            //   803d????????00       |                     
            //   7505                 | jne                 7
            //   e8????????           |                     

        $sequence_7 = { c5fe7f8540edffff c5fe6f8540edffff c5fe7f85c0feffff c5fd708520ffffff93 c5fe7f8520edffff c5fe6f8520edffff c5fe7f8520ffffff }
            // n = 7, score = 100
            //   c5fe7f8540edffff     | vmovdqu             ymmword ptr [ebp - 0x12c0], ymm0
            //   c5fe6f8540edffff     | vmovdqu             ymm0, ymmword ptr [ebp - 0x12c0]
            //   c5fe7f85c0feffff     | vmovdqu             ymmword ptr [ebp - 0x140], ymm0
            //   c5fd708520ffffff93     | vpshufd    ymm0, ymmword ptr [ebp - 0xe0], 0x93
            //   c5fe7f8520edffff     | vmovdqu             ymmword ptr [ebp - 0x12e0], ymm0
            //   c5fe6f8520edffff     | vmovdqu             ymm0, ymmword ptr [ebp - 0x12e0]
            //   c5fe7f8520ffffff     | vmovdqu             ymmword ptr [ebp - 0xe0], ymm0

        $sequence_8 = { 8b4004 8bce ffd0 0fb64d07 bb01000000 84c0 }
            // n = 6, score = 100
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   8bce                 | mov                 ecx, esi
            //   ffd0                 | call                eax
            //   0fb64d07             | movzx               ecx, byte ptr [ebp + 7]
            //   bb01000000           | mov                 ebx, 1
            //   84c0                 | test                al, al

        $sequence_9 = { 50 e8???????? 83c408 50 68???????? 8d4d5c e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   50                   | push                eax
            //   68????????           |                     
            //   8d4d5c               | lea                 ecx, [ebp + 0x5c]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2226176
}