rule win_fusiondrive_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fusiondrive."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fusiondrive"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 498bca e8???????? 90 4983fd08 7231 4a8d146d02000000 }
            // n = 6, score = 100
            //   498bca               | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 eax, esi
            //   4983fd08             | dec                 eax
            //   7231                 | sub                 eax, ebx
            //   4a8d146d02000000     | dec                 eax

        $sequence_1 = { 4883c420 5b c3 4883611000 488d05e8b50000 48894108 }
            // n = 6, score = 100
            //   4883c420             | dec                 eax
            //   5b                   | sub                 esp, 0x20
            //   c3                   | mov                 ebx, ecx
            //   4883611000           | dec                 esp
            //   488d05e8b50000       | lea                 ecx, [0xb675]
            //   48894108             | mov                 ecx, 2

        $sequence_2 = { 488d150b760100 488d4c2420 e8???????? cc 48895c2420 55 }
            // n = 6, score = 100
            //   488d150b760100       | dec                 eax
            //   488d4c2420           | lea                 edx, [0x721a]
            //   e8????????           |                     
            //   cc                   | dec                 eax
            //   48895c2420           | sub                 esp, 0x20
            //   55                   | mov                 ebx, ecx

        $sequence_3 = { 4c8d34c0 4a8b84e120e00100 4a8b44f028 488945b7 ff15???????? 33d2 }
            // n = 6, score = 100
            //   4c8d34c0             | dec                 eax
            //   4a8b84e120e00100     | mov                 ecx, ebx
            //   4a8b44f028           | dec                 eax
            //   488945b7             | test                eax, eax
            //   ff15????????         |                     
            //   33d2                 | dec                 eax

        $sequence_4 = { 4488742470 eb22 488d3da7290100 eb19 }
            // n = 4, score = 100
            //   4488742470           | push                edi
            //   eb22                 | dec                 eax
            //   488d3da7290100       | sub                 esp, 0x20
            //   eb19                 | mov                 edi, ecx

        $sequence_5 = { 488b05???????? 483b4208 7520 488bc1 4883c110 33d2 4885c0 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   483b4208             | dec                 ecx
            //   7520                 | mov                 dword ptr [ecx + 8], edx
            //   488bc1               | inc                 ecx
            //   4883c110             | mov                 dword ptr [ecx + 0x1c], eax
            //   33d2                 | movzx               ecx, byte ptr [edx]
            //   4885c0               | inc                 edx

        $sequence_6 = { 33d2 33c9 ff15???????? 488d0da0620100 eb0c 83f901 750d }
            // n = 7, score = 100
            //   33d2                 | mov                 ecx, ebx
            //   33c9                 | dec                 eax
            //   ff15????????         |                     
            //   488d0da0620100       | test                eax, eax
            //   eb0c                 | mov                 ecx, 2
            //   83f901               | dec                 esp
            //   750d                 | lea                 eax, [0xb661]

        $sequence_7 = { 400fb6c7 488b8da0010000 4833cc e8???????? }
            // n = 4, score = 100
            //   400fb6c7             | xor                 ecx, ecx
            //   488b8da0010000       | dec                 eax
            //   4833cc               | lea                 edx, [0x1b9c6]
            //   e8????????           |                     

        $sequence_8 = { 488d442470 4889442428 897c2420 4533c9 }
            // n = 4, score = 100
            //   488d442470           | dec                 eax
            //   4889442428           | mov                 dword ptr [ecx + 8], edx
            //   897c2420             | movzx               ecx, byte ptr [edx]
            //   4533c9               | and                 ecx, 0xf

        $sequence_9 = { 498784f7e8d90100 4883c504 493bec e9???????? 488bc3 4c8d3d2792ffff 498784f7e8d90100 }
            // n = 7, score = 100
            //   498784f7e8d90100     | mov                 edi, edx
            //   4883c504             | dec                 eax
            //   493bec               | mov                 edx, dword ptr [edx]
            //   e9????????           |                     
            //   488bc3               | movzx               ecx, byte ptr [edx]
            //   4c8d3d2792ffff       | and                 ecx, 0xf
            //   498784f7e8d90100     | dec                 edx

    condition:
        7 of them and filesize < 290816
}