rule win_gameover_dga_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gameover_dga."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gameover_dga"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894c2414 50 51 8bce e8???????? 8bd8 85db }
            // n = 7, score = 700
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx

        $sequence_1 = { 7ed5 8b442418 3bd0 0f8426ebffff 837c241c00 8bcb 0f8525120000 }
            // n = 7, score = 700
            //   7ed5                 | jle                 0xffffffd7
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   3bd0                 | cmp                 edx, eax
            //   0f8426ebffff         | je                  0xffffeb2c
            //   837c241c00           | cmp                 dword ptr [esp + 0x1c], 0
            //   8bcb                 | mov                 ecx, ebx
            //   0f8525120000         | jne                 0x122b

        $sequence_2 = { 8be5 5d c3 56 e8???????? 84c0 74e1 }
            // n = 7, score = 700
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   56                   | push                esi
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   74e1                 | je                  0xffffffe3

        $sequence_3 = { c744242c05000000 e8???????? 6a37 8d54243c 59 e8???????? 56 }
            // n = 7, score = 700
            //   c744242c05000000     | mov                 dword ptr [esp + 0x2c], 5
            //   e8????????           |                     
            //   6a37                 | push                0x37
            //   8d54243c             | lea                 edx, [esp + 0x3c]
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   56                   | push                esi

        $sequence_4 = { 8b4604 0345f0 5e 8be5 5d c20c00 83ec14 }
            // n = 7, score = 700
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   0345f0               | add                 eax, dword ptr [ebp - 0x10]
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   83ec14               | sub                 esp, 0x14

        $sequence_5 = { 88442423 e8???????? 89442418 85c0 7425 8bc8 e8???????? }
            // n = 7, score = 700
            //   88442423             | mov                 byte ptr [esp + 0x23], al
            //   e8????????           |                     
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   85c0                 | test                eax, eax
            //   7425                 | je                  0x27
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_6 = { b001 c20400 51 f605????????01 56 57 8bf9 }
            // n = 7, score = 700
            //   b001                 | mov                 al, 1
            //   c20400               | ret                 4
            //   51                   | push                ecx
            //   f605????????01       |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx

        $sequence_7 = { 0f85500e0000 8b442438 5f 5e 5d 5b 83c420 }
            // n = 7, score = 700
            //   0f85500e0000         | jne                 0xe56
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   83c420               | add                 esp, 0x20

        $sequence_8 = { 0f94c0 c1e108 89442428 0fb64502 0bc8 0fb64503 c1e008 }
            // n = 7, score = 700
            //   0f94c0               | sete                al
            //   c1e108               | shl                 ecx, 8
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   0fb64502             | movzx               eax, byte ptr [ebp + 2]
            //   0bc8                 | or                  ecx, eax
            //   0fb64503             | movzx               eax, byte ptr [ebp + 3]
            //   c1e008               | shl                 eax, 8

        $sequence_9 = { 56 8bd9 57 8bf3 895c2414 6a00 83e601 }
            // n = 7, score = 700
            //   56                   | push                esi
            //   8bd9                 | mov                 ebx, ecx
            //   57                   | push                edi
            //   8bf3                 | mov                 esi, ebx
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   6a00                 | push                0
            //   83e601               | and                 esi, 1

    condition:
        7 of them and filesize < 540672
}