rule win_gamotrol_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gamotrol."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gamotrol"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f877b070000 ff2485ab062e00 834de0ff 897588 8975b0 8975c0 8975c4 }
            // n = 7, score = 100
            //   0f877b070000         | ja                  0x781
            //   ff2485ab062e00       | jmp                 dword ptr [eax*4 + 0x2e06ab]
            //   834de0ff             | or                  dword ptr [ebp - 0x20], 0xffffffff
            //   897588               | mov                 dword ptr [ebp - 0x78], esi
            //   8975b0               | mov                 dword ptr [ebp - 0x50], esi
            //   8975c0               | mov                 dword ptr [ebp - 0x40], esi
            //   8975c4               | mov                 dword ptr [ebp - 0x3c], esi

        $sequence_1 = { 8d45cc 50 897dcc c745f064da2e00 c745e810000000 e8???????? }
            // n = 6, score = 100
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   897dcc               | mov                 dword ptr [ebp - 0x34], edi
            //   c745f064da2e00       | mov                 dword ptr [ebp - 0x10], 0x2eda64
            //   c745e810000000       | mov                 dword ptr [ebp - 0x18], 0x10
            //   e8????????           |                     

        $sequence_2 = { 83c447 83ec47 41 49 }
            // n = 4, score = 100
            //   83c447               | add                 esp, 0x47
            //   83ec47               | sub                 esp, 0x47
            //   41                   | inc                 ecx
            //   49                   | dec                 ecx

        $sequence_3 = { 8bc6 c1f805 83e61f 6bf628 033485c09e2f00 }
            // n = 5, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   83e61f               | and                 esi, 0x1f
            //   6bf628               | imul                esi, esi, 0x28
            //   033485c09e2f00       | add                 esi, dword ptr [eax*4 + 0x2f9ec0]

        $sequence_4 = { 8be5 90 5d 6803010000 }
            // n = 4, score = 100
            //   8be5                 | mov                 esp, ebp
            //   90                   | nop                 
            //   5d                   | pop                 ebp
            //   6803010000           | push                0x103

        $sequence_5 = { 03f7 85c0 8975ec 0f86f7000000 8d1c83 90 }
            // n = 6, score = 100
            //   03f7                 | add                 esi, edi
            //   85c0                 | test                eax, eax
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   0f86f7000000         | jbe                 0xfd
            //   8d1c83               | lea                 ebx, [ebx + eax*4]
            //   90                   | nop                 

        $sequence_6 = { 50 ff742410 ff742410 ff742420 ff742420 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   ff742420             | push                dword ptr [esp + 0x20]

        $sequence_7 = { 83c001 83c728 3bc1 8945f8 0f8caafeffff 5f 5e }
            // n = 7, score = 100
            //   83c001               | add                 eax, 1
            //   83c728               | add                 edi, 0x28
            //   3bc1                 | cmp                 eax, ecx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   0f8caafeffff         | jl                  0xfffffeb0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { 8be5 90 5d 6aff 6a00 68???????? 6a00 }
            // n = 7, score = 100
            //   8be5                 | mov                 esp, ebp
            //   90                   | nop                 
            //   5d                   | pop                 ebp
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_9 = { 830d????????ff 33c0 68???????? c705????????e4dd2e00 c705????????54dd2e00 }
            // n = 5, score = 100
            //   830d????????ff       |                     
            //   33c0                 | xor                 eax, eax
            //   68????????           |                     
            //   c705????????e4dd2e00     |     
            //   c705????????54dd2e00     |     

    condition:
        7 of them and filesize < 376832
}