rule win_gcleaner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gcleaner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gcleaner"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd0 c645fc04 8d4dd8 e8???????? 83c410 }
            // n = 5, score = 700
            //   8bd0                 | mov                 edx, eax
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_1 = { c645fc02 8d4da8 e8???????? 57 }
            // n = 4, score = 700
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_2 = { 8035????????2e 8035????????2e 8035????????2e 342e }
            // n = 4, score = 700
            //   8035????????2e       |                     
            //   8035????????2e       |                     
            //   8035????????2e       |                     
            //   342e                 | xor                 al, 0x2e

        $sequence_3 = { 6800004080 6a00 6a00 6a00 }
            // n = 4, score = 700
            //   6800004080           | push                0x80400000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_4 = { 89b5f4feffff ff15???????? 8bf8 85ff }
            // n = 4, score = 700
            //   89b5f4feffff         | mov                 dword ptr [ebp - 0x10c], esi
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi

        $sequence_5 = { 5e c9 c3 53 ff7518 }
            // n = 5, score = 700
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   ff7518               | push                dword ptr [ebp + 0x18]

        $sequence_6 = { 7404 2bfb eb03 83cfff 3bf7 }
            // n = 5, score = 700
            //   7404                 | je                  6
            //   2bfb                 | sub                 edi, ebx
            //   eb03                 | jmp                 5
            //   83cfff               | or                  edi, 0xffffffff
            //   3bf7                 | cmp                 esi, edi

        $sequence_7 = { 8035????????2e 8035????????2e 342e a2???????? }
            // n = 4, score = 700
            //   8035????????2e       |                     
            //   8035????????2e       |                     
            //   342e                 | xor                 al, 0x2e
            //   a2????????           |                     

        $sequence_8 = { 6a04 8d85f0feffff 50 56 }
            // n = 4, score = 700
            //   6a04                 | push                4
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_9 = { 8d8d60ffffff e8???????? 6a00 6a00 8d4dd8 e8???????? 50 }
            // n = 7, score = 700
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   50                   | push                eax

    condition:
        7 of them and filesize < 540672
}