rule win_gcman_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gcman."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gcman"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744240400100000 8d85d8efffff 890424 e8???????? 8d85d8efffff }
            // n = 5, score = 100
            //   c744240400100000     | mov                 dword ptr [esp + 4], 0x1000
            //   8d85d8efffff         | lea                 eax, [ebp - 0x1028]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8d85d8efffff         | lea                 eax, [ebp - 0x1028]

        $sequence_1 = { c74008fedcba98 8b4508 c7400c76543210 8b4508 }
            // n = 4, score = 100
            //   c74008fedcba98       | mov                 dword ptr [eax + 8], 0x98badcfe
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c7400c76543210       | mov                 dword ptr [eax + 0xc], 0x10325476
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { 89c2 83e230 8b4508 40 0fb600 }
            // n = 5, score = 100
            //   89c2                 | mov                 edx, eax
            //   83e230               | and                 edx, 0x30
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   40                   | inc                 eax
            //   0fb600               | movzx               eax, byte ptr [eax]

        $sequence_3 = { 898590e7ffff 833d????????00 750a c78590e7ffffdd624000 8b8590e7ffff 8944240c c7442408???????? }
            // n = 7, score = 100
            //   898590e7ffff         | mov                 dword ptr [ebp - 0x1870], eax
            //   833d????????00       |                     
            //   750a                 | jne                 0xc
            //   c78590e7ffffdd624000     | mov    dword ptr [ebp - 0x1870], 0x4062dd
            //   8b8590e7ffff         | mov                 eax, dword ptr [ebp - 0x1870]
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   c7442408????????     |                     

        $sequence_4 = { 8b4508 890424 e8???????? 8d0403 }
            // n = 4, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8d0403               | lea                 eax, [ebx + eax]

        $sequence_5 = { 8b00 c1e818 8802 8b5508 83c204 8b450c 8b4004 }
            // n = 7, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   c1e818               | shr                 eax, 0x18
            //   8802                 | mov                 byte ptr [edx], al
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83c204               | add                 edx, 4
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_6 = { 8b4df0 01c1 8b45f4 89c2 c1e206 b0c0 20d0 }
            // n = 7, score = 100
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   01c1                 | add                 ecx, eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   89c2                 | mov                 edx, eax
            //   c1e206               | shl                 edx, 6
            //   b0c0                 | mov                 al, 0xc0
            //   20d0                 | and                 al, dl

        $sequence_7 = { 31ce 0375a8 01f3 81eb06d85e15 c1c30b 01c3 }
            // n = 6, score = 100
            //   31ce                 | xor                 esi, ecx
            //   0375a8               | add                 esi, dword ptr [ebp - 0x58]
            //   01f3                 | add                 ebx, esi
            //   81eb06d85e15         | sub                 ebx, 0x155ed806
            //   c1c30b               | rol                 ebx, 0xb
            //   01c3                 | add                 ebx, eax

        $sequence_8 = { c1c004 01d0 89c6 31d6 31ce 0375a8 01f3 }
            // n = 7, score = 100
            //   c1c004               | rol                 eax, 4
            //   01d0                 | add                 eax, edx
            //   89c6                 | mov                 esi, eax
            //   31d6                 | xor                 esi, edx
            //   31ce                 | xor                 esi, ecx
            //   0375a8               | add                 esi, dword ptr [ebp - 0x58]
            //   01f3                 | add                 ebx, esi

        $sequence_9 = { 40 890424 e8???????? 8945fc 8b45fc 89442408 8b450c }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 81920
}