rule win_gh0sttimes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gh0sttimes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gh0sttimes"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c68598fcffff05 889d99fcffff ff15???????? 68???????? 8d841d9bfcffff 50 }
            // n = 6, score = 800
            //   c68598fcffff05       | mov                 byte ptr [ebp - 0x368], 5
            //   889d99fcffff         | mov                 byte ptr [ebp - 0x367], bl
            //   ff15????????         |                     
            //   68????????           |                     
            //   8d841d9bfcffff       | lea                 eax, [ebp + ebx - 0x365]
            //   50                   | push                eax

        $sequence_1 = { c685b4feffff6d e8???????? eb05 e8???????? }
            // n = 4, score = 800
            //   c685b4feffff6d       | mov                 byte ptr [ebp - 0x14c], 0x6d
            //   e8????????           |                     
            //   eb05                 | jmp                 7
            //   e8????????           |                     

        $sequence_2 = { ffd3 8b3f 85ff 0f844f020000 }
            // n = 4, score = 800
            //   ffd3                 | call                ebx
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   85ff                 | test                edi, edi
            //   0f844f020000         | je                  0x255

        $sequence_3 = { e8???????? 83f8ff 7510 57 ff15???????? }
            // n = 5, score = 800
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7510                 | jne                 0x12
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_4 = { 6a01 8d4d08 8bd6 c645086b e8???????? e9???????? 33ff }
            // n = 7, score = 800
            //   6a01                 | push                1
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   8bd6                 | mov                 edx, esi
            //   c645086b             | mov                 byte ptr [ebp + 8], 0x6b
            //   e8????????           |                     
            //   e9????????           |                     
            //   33ff                 | xor                 edi, edi

        $sequence_5 = { e8???????? 8bfc 57 56 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   8bfc                 | mov                 edi, esp
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_6 = { ffd3 e9???????? 8b8d8cfeffff 8b8588feffff 894e24 6a01 }
            // n = 6, score = 800
            //   ffd3                 | call                ebx
            //   e9????????           |                     
            //   8b8d8cfeffff         | mov                 ecx, dword ptr [ebp - 0x174]
            //   8b8588feffff         | mov                 eax, dword ptr [ebp - 0x178]
            //   894e24               | mov                 dword ptr [esi + 0x24], ecx
            //   6a01                 | push                1

        $sequence_7 = { c7858cfcffff03000000 c78590fcffff00000000 c68594fcffff05 889d95fcffff c68596fcffff00 889d97fcffff }
            // n = 6, score = 800
            //   c7858cfcffff03000000     | mov    dword ptr [ebp - 0x374], 3
            //   c78590fcffff00000000     | mov    dword ptr [ebp - 0x370], 0
            //   c68594fcffff05       | mov                 byte ptr [ebp - 0x36c], 5
            //   889d95fcffff         | mov                 byte ptr [ebp - 0x36b], bl
            //   c68596fcffff00       | mov                 byte ptr [ebp - 0x36a], 0
            //   889d97fcffff         | mov                 byte ptr [ebp - 0x369], bl

        $sequence_8 = { 488b4c2438 488d442430 488d15da700200 4889442428 }
            // n = 4, score = 600
            //   488b4c2438           | and                 eax, esp
            //   488d442430           | xor                 dword ptr [ecx + 8], eax
            //   488d15da700200       | dec                 eax
            //   4889442428           | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_9 = { 488b8f40010000 ff15???????? 488b8f40010000 ff15???????? 48c78740010000ffffffff 488b8c2490000000 4833cc }
            // n = 7, score = 600
            //   488b8f40010000       | dec                 eax
            //   ff15????????         |                     
            //   488b8f40010000       | mov                 ecx, dword ptr [edi + 0x140]
            //   ff15????????         |                     
            //   48c78740010000ffffffff     | dec    eax
            //   488b8c2490000000     | mov                 ecx, dword ptr [edi + 0x140]
            //   4833cc               | dec                 eax

        $sequence_10 = { 488b4c2430 488b4968 e8???????? 4c8b5c2430 }
            // n = 4, score = 600
            //   488b4c2430           | mov                 word ptr [ecx + edx*2], ax
            //   488b4968             | dec                 eax
            //   e8????????           |                     
            //   4c8b5c2430           | mov                 eax, dword ptr [esp + 0x30]

        $sequence_11 = { 488b4c2438 488d442434 4c8d4c2430 4889442428 488d442440 488d1520790200 }
            // n = 6, score = 600
            //   488b4c2438           | dec                 eax
            //   488d442434           | lea                 eax, [esp + 0x30]
            //   4c8d4c2430           | dec                 eax
            //   4889442428           | lea                 edx, [0x2710c]
            //   488d442440           | dec                 eax
            //   488d1520790200       | mov                 dword ptr [esp + 0x28], eax

        $sequence_12 = { 488b4c2430 488b4968 33c0 66890451 488b442430 }
            // n = 5, score = 600
            //   488b4c2430           | mov                 dword ptr [edi + 0x140], 0xffffffff
            //   488b4968             | dec                 eax
            //   33c0                 | mov                 ecx, dword ptr [esp + 0x90]
            //   66890451             | dec                 eax
            //   488b442430           | xor                 ecx, esp

        $sequence_13 = { 488b4c2430 48c1e80c f7d0 334108 }
            // n = 4, score = 600
            //   488b4c2430           | mov                 eax, dword ptr [eax + 0x74]
            //   48c1e80c             | sub                 eax, 1
            //   f7d0                 | dec                 eax
            //   334108               | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_14 = { 488b4c2438 488d442430 488d150c710200 4889442428 }
            // n = 4, score = 600
            //   488b4c2438           | dec                 eax
            //   488d442430           | shr                 eax, 0xc
            //   488d150c710200       | not                 eax
            //   4889442428           | xor                 eax, dword ptr [ecx + 8]

        $sequence_15 = { 488b4c2430 83490c08 a808 7409 488b442430 83480c04 }
            // n = 6, score = 600
            //   488b4c2430           | mov                 ebx, dword ptr [esp + 0x30]
            //   83490c08             | dec                 ecx
            //   a808                 | arpl                word ptr [ebx + 0xac], cx
            //   7409                 | dec                 eax
            //   488b442430           | imul                ecx, ecx, 0x10
            //   83480c04             | dec                 eax

    condition:
        7 of them and filesize < 548864
}