rule win_ghole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ghole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghole"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d5002 48 8bcd e8???????? 48 85c0 48 }
            // n = 7, score = 100
            //   8d5002               | lea                 edx, [eax + 2]
            //   48                   | dec                 eax
            //   8bcd                 | mov                 ecx, ebp
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   48                   | dec                 eax

        $sequence_1 = { 48 8b45d0 48 8b4038 48 8945e8 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   48                   | dec                 eax
            //   8b4038               | mov                 eax, dword ptr [eax + 0x38]
            //   48                   | dec                 eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   48                   | dec                 eax

        $sequence_2 = { 89c7 e8???????? 48 8d45d0 be10000000 48 89c7 }
            // n = 7, score = 100
            //   89c7                 | mov                 edi, eax
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   be10000000           | mov                 esi, 0x10
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax

        $sequence_3 = { 85c0 7422 48 8d85d0feffff ba00000000 be00000000 48 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7422                 | je                  0x24
            //   48                   | dec                 eax
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   ba00000000           | mov                 edx, 0
            //   be00000000           | mov                 esi, 0
            //   48                   | dec                 eax

        $sequence_4 = { 837df007 750a b800000000 e9???????? 48 8b45e8 }
            // n = 6, score = 100
            //   837df007             | cmp                 dword ptr [ebp - 0x10], 7
            //   750a                 | jne                 0xc
            //   b800000000           | mov                 eax, 0
            //   e9????????           |                     
            //   48                   | dec                 eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_5 = { 4c 896c2450 48 8bd8 4c 8bee 7458 }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   896c2450             | mov                 dword ptr [esp + 0x50], ebp
            //   48                   | dec                 eax
            //   8bd8                 | mov                 ebx, eax
            //   4c                   | dec                 esp
            //   8bee                 | mov                 ebp, esi
            //   7458                 | je                  0x5a

        $sequence_6 = { 8b45e4 48 98 48 0345e8 c60000 }
            // n = 6, score = 100
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   48                   | dec                 eax
            //   98                   | cwde                
            //   48                   | dec                 eax
            //   0345e8               | add                 eax, dword ptr [ebp - 0x18]
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_7 = { 48 8d3d324b0100 e8???????? b800000000 e9???????? 48 8b05???????? }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8d3d324b0100         | lea                 edi, [0x14b32]
            //   e8????????           |                     
            //   b800000000           | mov                 eax, 0
            //   e9????????           |                     
            //   48                   | dec                 eax
            //   8b05????????         |                     

        $sequence_8 = { 48 83c608 668b147b 48 8d1c7b 6685d2 759b }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   83c608               | add                 esi, 8
            //   668b147b             | mov                 dx, word ptr [ebx + edi*2]
            //   48                   | dec                 eax
            //   8d1c7b               | lea                 ebx, [ebx + edi*2]
            //   6685d2               | test                dx, dx
            //   759b                 | jne                 0xffffff9d

        $sequence_9 = { 897de8 48 8975e0 8955dc 48 894dd0 4c }
            // n = 7, score = 100
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   48                   | dec                 eax
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   48                   | dec                 eax
            //   894dd0               | mov                 dword ptr [ebp - 0x30], ecx
            //   4c                   | dec                 esp

    condition:
        7 of them and filesize < 622592
}