rule win_globeimposter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.globeimposter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.globeimposter"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fd4e5 0f7e4f0c 0f73d120 0fd4ca }
            // n = 4, score = 700
            //   0fd4e5               | paddq               mm4, mm5
            //   0f7e4f0c             | movd                dword ptr [edi + 0xc], mm1
            //   0f73d120             | psrlq               mm1, 0x20
            //   0fd4ca               | paddq               mm1, mm2

        $sequence_1 = { 33db 8b7d04 85ff 7413 8b4508 8d04b8 }
            // n = 6, score = 700
            //   33db                 | xor                 ebx, ebx
            //   8b7d04               | mov                 edi, dword ptr [ebp + 4]
            //   85ff                 | test                edi, edi
            //   7413                 | je                  0x15
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d04b8               | lea                 eax, [eax + edi*4]

        $sequence_2 = { ff15???????? 03c7 50 ff15???????? 85c0 743b 8b7c2410 }
            // n = 7, score = 700
            //   ff15????????         |                     
            //   03c7                 | add                 eax, edi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   743b                 | je                  0x3d
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]

        $sequence_3 = { 43 85d2 7e18 8d4e7c 8b41fc 3b01 }
            // n = 6, score = 700
            //   43                   | inc                 ebx
            //   85d2                 | test                edx, edx
            //   7e18                 | jle                 0x1a
            //   8d4e7c               | lea                 ecx, [esi + 0x7c]
            //   8b41fc               | mov                 eax, dword ptr [ecx - 4]
            //   3b01                 | cmp                 eax, dword ptr [ecx]

        $sequence_4 = { 0f6e6614 0ff4e0 0fd4cb 0f6e7618 0ff4f0 0f7e4f04 0f73d120 }
            // n = 7, score = 700
            //   0f6e6614             | movd                mm4, dword ptr [esi + 0x14]
            //   0ff4e0               | pmuludq             mm4, mm0
            //   0fd4cb               | paddq               mm1, mm3
            //   0f6e7618             | movd                mm6, dword ptr [esi + 0x18]
            //   0ff4f0               | pmuludq             mm6, mm0
            //   0f7e4f04             | movd                dword ptr [edi + 4], mm1
            //   0f73d120             | psrlq               mm1, 0x20

        $sequence_5 = { 750b ff15???????? 6ac4 58 eb0a ff15???????? }
            // n = 6, score = 700
            //   750b                 | jne                 0xd
            //   ff15????????         |                     
            //   6ac4                 | push                -0x3c
            //   58                   | pop                 eax
            //   eb0a                 | jmp                 0xc
            //   ff15????????         |                     

        $sequence_6 = { 5e eb05 b800afffff 5f }
            // n = 4, score = 700
            //   5e                   | pop                 esi
            //   eb05                 | jmp                 7
            //   b800afffff           | mov                 eax, 0xffffaf00
            //   5f                   | pop                 edi

        $sequence_7 = { ff15???????? 6ac4 58 eb0a ff15???????? 8937 }
            // n = 6, score = 700
            //   ff15????????         |                     
            //   6ac4                 | push                -0x3c
            //   58                   | pop                 eax
            //   eb0a                 | jmp                 0xc
            //   ff15????????         |                     
            //   8937                 | mov                 dword ptr [edi], esi

        $sequence_8 = { 8bd0 85d2 7514 8b4608 8d0ca8 0119 3919 }
            // n = 7, score = 700
            //   8bd0                 | mov                 edx, eax
            //   85d2                 | test                edx, edx
            //   7514                 | jne                 0x16
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8d0ca8               | lea                 ecx, [eax + ebp*4]
            //   0119                 | add                 dword ptr [ecx], ebx
            //   3919                 | cmp                 dword ptr [ecx], ebx

        $sequence_9 = { ff742440 e8???????? 83c40c 8bc5 eb03 6ac4 }
            // n = 6, score = 700
            //   ff742440             | push                dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8bc5                 | mov                 eax, ebp
            //   eb03                 | jmp                 5
            //   6ac4                 | push                -0x3c

    condition:
        7 of them and filesize < 327680
}